/*
 * Decompiled with CFR 0.152.
 */
package kim.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class Tabs
extends Canvas {
    protected Color textInactive = new Color(80, 80, 80);
    protected Color textActive = Color.black;
    protected Color backgroundColor = new Color(100, 100, 100);
    protected Color tabInactiveColor = new Color(150, 150, 150);
    protected Color tabActiveColor;
    Image tabImage;
    int width = 600;
    int height = 23;
    int numberOfTabs = 6;
    int activeTab = 2;
    String[] text;
    int[] tabStart = new int[this.numberOfTabs];
    int tabWidth;
    Polygon[] whitePolygon = new Polygon[this.numberOfTabs];
    Polygon[] blackPolygon = new Polygon[this.numberOfTabs];
    int[][] lines = new int[this.numberOfTabs][4];
    int x;
    int y;

    public void init() {
        this.tabActiveColor = super.getBackground();
        this.uitrekenen();
        this.setBackground(this.backgroundColor);
    }

    public Tabs(int i, int j, int k, int l, String[] as, Color color) {
        this.width = k;
        this.height = l;
        this.numberOfTabs = i;
        this.activeTab = j;
        this.text = as;
        this.tabActiveColor = color;
        this.uitrekenen();
        this.setBackground(this.backgroundColor);
    }

    public void uitrekenen() {
        this.tabWidth = (this.width - this.height / 2) / this.numberOfTabs + this.height / 2;
        for (int i = 0; i < this.numberOfTabs; ++i) {
            this.tabStart[i] = i * (this.tabWidth - this.height / 2);
            int j = this.tabStart[i];
            int[] ai = new int[]{j, this.height / 2 + j, j + this.tabWidth - this.height / 2, j + this.tabWidth, this.tabStart[i]};
            int[] ai1 = new int[]{this.height, 0, 0, this.height, this.height};
            this.blackPolygon[i] = new Polygon(ai, ai1, 5);
            this.whitePolygon[i] = new Polygon(ai, ai1, 3);
            this.lines[i][0] = j;
            this.lines[i][1] = this.height;
            this.lines[i][2] = this.tabWidth + j;
            this.lines[i][3] = this.height;
        }
    }

    @Override
    public boolean mouseDown(Event event, int i, int j) {
        if (this.blackPolygon[this.activeTab - 1].inside(i, j)) {
            return true;
        }
        for (int k = 0; k < this.numberOfTabs; ++k) {
            if (!this.blackPolygon[k].inside(i, j)) continue;
            this.activeTab = k + 1;
            this.repaint();
            k = this.numberOfTabs;
            return true;
        }
        return false;
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.width, this.height + 1);
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(this.width, this.height + 1);
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
        for (int i = this.numberOfTabs - 1; i >= 0; --i) {
            this.y = this.height - 1 - fontmetrics.getHeight() / 2;
            this.x = (this.tabWidth - fontmetrics.stringWidth(this.text[i])) / 2;
            g.setColor(this.tabInactiveColor);
            g.fillPolygon(this.blackPolygon[i]);
            g.setColor(Color.black);
            g.drawPolygon(this.blackPolygon[i]);
            g.setColor(this.textInactive);
            g.drawString(this.text[i], this.tabStart[i] + this.x, this.y);
            g.setColor(Color.white);
            g.drawPolygon(this.whitePolygon[i]);
        }
        this.x = (this.tabWidth - fontmetrics.stringWidth(this.text[this.activeTab - 1])) / 2;
        g.setColor(Color.black);
        g.drawLine(0, this.height, this.width, this.height);
        g.setColor(this.tabActiveColor);
        g.fillPolygon(this.blackPolygon[this.activeTab - 1]);
        g.setColor(Color.black);
        g.drawPolygon(this.blackPolygon[this.activeTab - 1]);
        g.setColor(this.tabActiveColor);
        g.drawLine(this.lines[this.activeTab - 1][0], this.lines[this.activeTab - 1][1], this.lines[this.activeTab - 1][2], this.lines[this.activeTab - 1][3]);
        g.setColor(Color.white);
        g.drawPolygon(this.whitePolygon[this.activeTab - 1]);
        g.setColor(Color.black);
        g.drawString(this.text[this.activeTab - 1], this.tabStart[this.activeTab - 1] + this.x, this.y);
    }

    public int getActiveTab() {
        return this.activeTab;
    }

    public void setActiveTab(int x) {
        this.activeTab = x;
    }
}

