/*
 * Decompiled with CFR 0.152.
 */
package kim.swing.JTable;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import kim.swing.JTable.DefaultTableHeaderCellRenderer;
import kim.swing.JTable.VerticalLabelUI;

public class VerticalTableHeaderCellRenderer
extends DefaultTableHeaderCellRenderer {
    private static final long serialVersionUID = 1L;

    public VerticalTableHeaderCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(0);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(1);
        this.setUI(new VerticalLabelUI());
    }

    @Override
    protected Icon getIcon(JTable table, int column) {
        RowSorter.SortKey sortKey = this.getSortKey(table, column);
        if (sortKey != null && table.convertColumnIndexToView(sortKey.getColumn()) == column) {
            SortOrder sortOrder = sortKey.getSortOrder();
            switch (sortOrder) {
                case ASCENDING: {
                    return VerticalSortIcon.ASCENDING;
                }
                case DESCENDING: {
                    return VerticalSortIcon.DESCENDING;
                }
            }
        }
        return null;
    }

    private static enum VerticalSortIcon implements Icon
    {
        ASCENDING(UIManager.getIcon("Table.ascendingSortIcon")),
        DESCENDING(UIManager.getIcon("Table.descendingSortIcon"));

        private final Icon icon;

        private VerticalSortIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int maxSide = Math.max(this.getIconWidth(), this.getIconHeight());
            Graphics2D g2 = (Graphics2D)g.create(x, y, maxSide, maxSide);
            g2.rotate(1.5707963267948966);
            g2.translate(0, -maxSide);
            this.icon.paintIcon(c, g2, 0, 0);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconWidth();
        }
    }
}

