/*
 * Decompiled with CFR 0.152.
 */
package kim.math.sort;

public class ObjectHeapSort {
    private double[] a;
    private Object[] o;

    public ObjectHeapSort(double[] sizes, Object[] obj) {
        this.a = sizes;
        this.o = obj;
        this.Heapify(this.a, this.o);
        for (int i = this.a.length - 1; i >= 0; --i) {
            this.DeleteMax(i, this.a, this.o);
        }
    }

    public double[] getSortedSizes() {
        return this.a;
    }

    public Object[] getSortedObjects() {
        return this.o;
    }

    private void Heapify(double[] a, Object[] o) {
        for (int i = a.length / 2; i >= 0; --i) {
            this.BubbleDown(i, a, o, a.length - 1);
        }
    }

    private void BubbleDown(int i, double[] a, Object[] o, int size) {
        double topSize = a[i];
        Object topObject = o[i];
        int root = i;
        while (root * 2 + 1 <= size) {
            if (root * 2 + 1 == size || a[root * 2 + 1] > a[root * 2 + 2]) {
                if (a[root * 2 + 1] < topSize) break;
                a[root] = a[root * 2 + 1];
                o[root] = o[root * 2 + 1];
                root = root * 2 + 1;
                continue;
            }
            if (a[root * 2 + 2] < topSize) break;
            a[root] = a[root * 2 + 2];
            o[root] = o[root * 2 + 2];
            root = root * 2 + 2;
        }
        a[root] = topSize;
        o[root] = topObject;
    }

    private void DeleteMax(int i, double[] a, Object[] o) {
        this.swap(0, i, a, o);
        this.BubbleDown(0, a, o, i - 1);
    }

    private void swap(int i, int j, double[] a, Object[] o) {
        double tempSize = a[i];
        a[i] = a[j];
        a[j] = tempSize;
        Object tempObject = o[i];
        o[i] = o[j];
        o[j] = tempObject;
    }
}

