/*
 * Decompiled with CFR 0.152.
 */
package kim.math;

import commonSense.math.linear.Matrix;
import edu.cornell.lassp.houle.RngPack.RanMT;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;

public final class Random {
    static RandomElement chance = new RanMT(RandomSeedable.ClockSeed());

    private Random() {
    }

    public static int singleInt(int maxValue) {
        return (int)chance.uniform(0.0, maxValue);
    }

    public static int singleInt(int maxValue, RandomElement random) {
        return (int)random.uniform(0.0, maxValue);
    }

    public static int[] multiInt(int maxValue, int arrayLenght) {
        int[] a = new int[arrayLenght];
        for (int x = 0; x < arrayLenght; ++x) {
            a[x] = Random.singleInt(maxValue);
        }
        return a;
    }

    public static int[] multiInt(int maxValue, int arrayLenght, RandomElement random) {
        int[] a = new int[arrayLenght];
        for (int x = 0; x < arrayLenght; ++x) {
            a[x] = Random.singleInt(maxValue, random);
        }
        return a;
    }

    public static int[] seriesInt(int arrayLenght) {
        double[] a = new double[arrayLenght];
        for (int x = 0; x < arrayLenght; ++x) {
            a[x] = Random.singleDouble(1.0);
        }
        int[] b = new int[arrayLenght];
        for (int z = 0; z < arrayLenght; ++z) {
            double smallest = 2.0;
            int y = 0;
            int change = 0;
            double r = 0.0;
            change = 0;
            for (y = 0; y < arrayLenght; ++y) {
                double d;
                r = a[y];
                if (!(d < smallest)) continue;
                smallest = r;
                change = y;
            }
            b[z] = change + 1;
            a[change] = 2.0;
        }
        return b;
    }

    public static int[] seriesInt(int arrayLenght, RandomElement random) {
        double[] a = new double[arrayLenght];
        for (int x = 0; x < arrayLenght; ++x) {
            a[x] = Random.singleDouble(1.0, random);
        }
        int[] b = new int[arrayLenght];
        for (int z = 0; z < arrayLenght; ++z) {
            double smallest = 2.0;
            int y = 0;
            int change = 0;
            double r = 0.0;
            change = 0;
            for (y = 0; y < arrayLenght; ++y) {
                double d;
                r = a[y];
                if (!(d < smallest)) continue;
                smallest = r;
                change = y;
            }
            b[z] = change + 1;
            a[change] = 2.0;
        }
        return b;
    }

    public static double singleDouble(double maxValue) {
        return chance.uniform(0.0, maxValue);
    }

    public static double singleDouble(double maxValue, RandomElement random) {
        return random.uniform(0.0, maxValue);
    }

    public static float singleFloat(double maxValue) {
        return (float)chance.uniform(0.0, maxValue);
    }

    public static double[] multiDouble(double maxValue, int arrayLenght) {
        double[] a = new double[arrayLenght];
        for (int x = 0; x < arrayLenght; ++x) {
            a[x] = chance.uniform(0.0, maxValue);
        }
        return a;
    }

    public static Matrix doubleMatrix(double minValue, double maxValue, int rows, int columns) {
        Matrix m = new Matrix(rows, columns);
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < columns; ++y) {
                m.setEntry(x, y, chance.uniform(minValue, maxValue));
            }
        }
        return m;
    }

    public static Matrix doubleMatrix(double maxValue, int rows, int columns) {
        return Random.doubleMatrix(0.0, maxValue, rows, columns);
    }
}

