/*
 * Decompiled with CFR 0.152.
 */
package kim.image.advanced;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;

public class SinglePixelFilters {
    public static BufferedImage threshold(BufferedImage image, int threshold) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int newValue = 0;
        int count = 0;
        for (int j = 0; j < height; ++j) {
            int i = 0;
            while (i < width) {
                newValue = (data[j * width + i] & 0xFF) > threshold ? 255 : 0;
                db.setElem(count, (byte)newValue);
                ++i;
                ++count;
            }
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static int[][] threshold(int[][] data, int threshold) {
        int rows = data.length;
        int columns = data[0].length;
        int[][] BWData = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                BWData[i][j] = data[i][j] > threshold ? 255 : 0;
            }
        }
        return BWData;
    }

    public static BufferedImage invert(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int count = 0;
        for (int j = 0; j < height; ++j) {
            int i = 0;
            while (i < width) {
                db.setElem(count, -data[count] + 1);
                ++i;
                ++count;
            }
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static int[][] invert(int[][] data) {
        int width = data.length;
        int height = data[0].length;
        int[][] invertedData = new int[width][height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                invertedData[j][i] = 255 - data[j][i];
            }
        }
        return invertedData;
    }
}

