/*
 * Decompiled with CFR 0.152.
 */
package kim.image;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.widget.DisplayJAI;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JScrollPane;
import kim.image.ImageFile;
import kim.image.ScalableImage;

public class ScrollableImagePane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private BufferedImage image = null;
    private SeekableStream newImage = null;
    private SeekableStream oldImage = null;
    private RenderedImage scaledImage = null;
    private DisplayJAI imagePanel;
    private float scale = 1.1f;
    private boolean start = true;

    public ScrollableImagePane(File fileLocation, float scale) throws FileNotFoundException, IOException {
        this.scale = scale;
        this.newImage(fileLocation, scale);
    }

    public void rescaleImage(float scale) {
        this.scale = scale;
        this.scaledImage = ScalableImage.rescale(this.image, scale);
        if (this.start) {
            this.imagePanel = new DisplayJAI(this.scaledImage);
            this.setViewportView((Component)this.imagePanel);
            this.start = false;
        } else {
            this.imagePanel.set(this.scaledImage);
        }
    }

    public void set(File fileLocation) throws FileNotFoundException, IOException {
        this.newImage(fileLocation, this.scale);
    }

    private void newImage(File fileLocation, float scale) throws FileNotFoundException, IOException {
        this.scale = scale;
        this.oldImage = this.newImage;
        this.newImage = new FileSeekableStream(fileLocation);
        this.image = ImageFile.load(this.newImage, "tiff");
        if (scale == 1.0f) {
            if (this.start) {
                this.imagePanel = new DisplayJAI((RenderedImage)this.image);
                this.setViewportView((Component)this.imagePanel);
            } else {
                this.imagePanel.set((RenderedImage)this.image);
            }
        } else {
            this.rescaleImage(scale);
        }
        if (this.start) {
            this.start = false;
        } else if (this.oldImage != null) {
            this.oldImage.close();
        } else {
            System.out.println("ScrollableImagePane.newImage(): oldImage == null");
        }
    }
}

