/*
 * Decompiled with CFR 0.152.
 */
package kim.html;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import kim.awt.choice.PreLoadChoice;
import kim.util.GridBag;

public class Link
implements Serializable {
    static final long serialVersionUID = -7023729756732761080L;
    String target = "";
    String url = "";
    String name = "";
    String language = "";
    String language2 = "";
    Label urlText;
    PreLoadChoice languages;
    Button addLanguage;
    Dialog languageDialog;

    public Link(String name, String url, String target, String language, String language2) {
        this.name = name;
        this.url = url;
        this.target = target;
        this.language = language;
        this.language2 = language2;
    }

    public Link(String name, String url, String target) {
        this(name, url, target, "Not specified", "");
    }

    public Link(String name, String url) {
        this(name, url, "", "Not specified", "");
    }

    protected void makeLanguageDialog() {
        this.languageDialog = new Dialog(new Frame(), "Enter language", true);
        this.urlText = new Label(this.name);
        this.languages = new PreLoadChoice("languages");
        this.addLanguage = new Button("Add language");
        this.languageDialog.setLayout(new GridBagLayout());
        GridBag.constrain(this.languageDialog, this.urlText, 1, 1, 1, 1, 5, 5, 5, 5);
        GridBag.constrain(this.languageDialog, this.languages, 1, 2, 1, 1, 5, 5, 5, 5);
        GridBag.constrain(this.languageDialog, this.addLanguage, 1, 3, 1, 1, 5, 5, 5, 5);
        this.languageDialog.validate();
        this.languageDialog.pack();
        this.languageDialog.requestFocus();
        this.addLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Link.this.languageDialog.hide();
            }
        });
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public String getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public String getLanguage() {
        if (this.language == null) {
            if (this.languageDialog == null) {
                this.makeLanguageDialog();
            }
            this.languageDialog.show();
            this.language = this.languages.getSelectedItem();
            return this.languages.getSelectedItem();
        }
        return this.language;
    }

    public String getLanguage2() {
        if (this.language2 == "") {
            return null;
        }
        return this.language2;
    }

    public String toString() {
        return this.getHTML("");
    }

    public String getHTML(String languageCode) {
        return "<A HREF=\"" + this.url + "\" TARGET=\"EUTS\">" + this.name + "</A>";
    }

    public String getHTML(boolean includeLanguage, String languageCode) {
        if (includeLanguage) {
            if (this.getLanguage2() == null || this.getLanguage2().equals("--make a choice--")) {
                return "<A HREF=\"" + this.url + "\" TARGET=\"EUTS\">" + this.name + "</A> (in: " + System.getProperty(this.getLanguage() + "." + languageCode, this.getLanguage()) + ")";
            }
            return "<A HREF=\"" + this.url + "\" TARGET=\"EUTS\">" + this.name + "</A> (in: " + System.getProperty(this.getLanguage() + "." + languageCode, this.getLanguage()) + "; " + System.getProperty(this.getLanguage2() + "." + languageCode, this.getLanguage2()) + ")";
        }
        return this.getHTML(languageCode);
    }
}

