/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.list;

import java.awt.List;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class SortedList
extends List {
    boolean caseSensitive = true;

    public SortedList(int rows, boolean multi, boolean caseSensitive) {
        super(rows, multi);
        this.caseSensitive = caseSensitive;
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                char keyChar = e.getKeyChar();
                String[] listItems = SortedList.this.getItems();
                for (int x = 0; x < listItems.length; ++x) {
                    if (keyChar != listItems[x].toLowerCase().charAt(0)) continue;
                    boolean visible = SortedList.this.isIndexSelected(x);
                    SortedList.this.makeVisible(x);
                    if (visible) {
                        SortedList.this.select(x);
                        break;
                    }
                    SortedList.this.deselect(x);
                    break;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public void add(String item) {
        boolean itemAdded = false;
        int items = this.getItemCount();
        if (items == 0) {
            super.add(item);
            itemAdded = true;
        } else if (this.caseSensitive) {
            for (int x = 0; x < items; ++x) {
                if (item.compareTo(this.getItem(x)) >= 0) continue;
                super.add(item, x);
                itemAdded = true;
                break;
            }
        } else {
            for (int x = 0; x < items; ++x) {
                if (item.toLowerCase().compareTo(this.getItem(x).toLowerCase()) >= 0) continue;
                super.add(item, x);
                itemAdded = true;
                break;
            }
        }
        if (!itemAdded) {
            super.add(item);
        }
    }

    public void deselectAll() {
        int[] indexes = this.getSelectedIndexes();
        for (int x = 0; x < indexes.length; ++x) {
            this.deselect(indexes[x]);
        }
    }
}

