/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.list;

import java.awt.List;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import kim.io.file.ReadDataFile;

public class PreLoadList
extends List {
    public PreLoadList(String list, int rows, boolean multi) {
        super(rows, multi);
        String data = "";
        try {
            data = ReadDataFile.getData("kim" + File.separator + "preloadfiles" + File.separator + list + ".txt");
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        StringTokenizer st = new StringTokenizer(data, "\t\n\r");
        while (st.hasMoreTokens()) {
            this.add(st.nextToken());
        }
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                char keyChar = e.getKeyChar();
                String[] listItems = PreLoadList.this.getItems();
                for (int x = 0; x < listItems.length; ++x) {
                    if (keyChar != listItems[x].toLowerCase().charAt(0)) continue;
                    boolean visible = PreLoadList.this.isIndexSelected(x);
                    PreLoadList.this.makeVisible(x);
                    if (visible) {
                        PreLoadList.this.select(x);
                        break;
                    }
                    PreLoadList.this.deselect(x);
                    break;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void deselectAll() {
        int[] indexes = this.getSelectedIndexes();
        for (int x = 0; x < indexes.length; ++x) {
            this.deselect(indexes[x]);
        }
    }
}

