/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.univariate;

import commonSense.DifferentArrayLengthException;
import commonSense.math.MathException;
import commonSense.stats.distribution.ChiSquaredDistribution;

public class Bartlett {
    int df = 0;
    int n = 0;
    double chi = 0.0;

    public Bartlett(double[] variances, int[] sizes) throws DifferentArrayLengthException {
        if (variances.length != sizes.length) {
            throw new DifferentArrayLengthException("Length of variances (" + variances.length + ") differs from length of ni (" + sizes.length + ")");
        }
        this.n = variances.length;
        double SSvar = 0.0;
        double SSlog = 0.0;
        double cor = 0.0;
        int ni = 0;
        for (int x = 0; x < this.n; ++x) {
            ni = sizes[x] - 1;
            this.df += ni;
            SSvar += (double)ni * variances[x];
            SSlog += (double)ni * StrictMath.log(variances[x]);
            cor += 1.0 / (double)ni;
        }
        this.chi = ((double)this.df * StrictMath.log(SSvar / (double)this.df) - SSlog) / (1.0 + 1.0 / (3.0 * ((double)this.n - 1.0)) * (cor - 1.0 / (double)this.df));
    }

    public Bartlett(double[] variances, int size) {
        this.n = variances.length;
        double SSvar = 0.0;
        double SSlog = 0.0;
        double cor = 0.0;
        int ni = size - 1;
        for (int x = 0; x < this.n; ++x) {
            this.df += ni;
            SSvar += (double)ni * variances[x];
            SSlog += (double)ni * StrictMath.log(variances[x]);
            cor += 1.0 / (double)ni;
        }
        this.chi = ((double)this.df * StrictMath.log(SSvar / (double)this.df) - SSlog) / (1.0 + 1.0 / (3.0 * ((double)this.n - 1.0)) * (cor - 1.0 / (double)this.df));
    }

    public double getChiSquare() {
        return this.chi;
    }

    public double getSignificance() throws MathException {
        return 1.0 - new ChiSquaredDistribution(this.n - 1).cumulativeProbability(this.chi);
    }

    public static void main(String[] a) {
        double[] v = new double[]{0.0707, 0.1447, 0.0237, 0.0836, 0.2189, 0.177, 0.0791, 0.2331};
        int[] n = new int[]{18, 13, 17, 16, 8, 11, 10, 10};
        Bartlett b = new Bartlett(v, n);
        try {
            System.out.println(b.getSignificance());
            System.out.println(new ChiSquaredDistribution(7.0).inverseCumulativeProbability(0.99));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

