/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.regression;

import commonSense.math.MathException;
import commonSense.stats.regression.Correlation;
import java.io.Serializable;

public abstract class LinearRegression
extends Correlation
implements Serializable {
    protected double zeroSSxx = Double.NaN;
    protected double zeroSSyy = Double.NaN;
    protected double zeroSSxy = Double.NaN;
    protected double X = Double.NaN;
    protected double Y = Double.NaN;

    @Override
    public void clear() {
        super.clear();
        this.Y = Double.NaN;
        this.X = Double.NaN;
        this.zeroSSxx = Double.NaN;
        this.zeroSSyy = Double.NaN;
        this.zeroSSxy = Double.NaN;
    }

    public double getIntercept() {
        return this.getIntercept(this.getSlope());
    }

    public abstract double getSlope();

    public abstract double getSumOfSquaresTotal();

    public double getSumOfSquaresModel() {
        return this.getSumOfSquaresModel(this.getSlope());
    }

    public abstract double getSumOfSquaresModel(double var1);

    public double getSumOfSquaresError() {
        return this.getSumOfSquaresTotal() - this.getSumOfSquaresModel();
    }

    public double getMeanSquareError() {
        if (!Double.isNaN(this.Y)) {
            if (this.n < 2L) {
                return Double.NaN;
            }
            if (this.n < 3L) {
                return Double.NaN;
            }
        }
        return this.getSumOfSquaresError() / (double)this.df;
    }

    public double getSlopeStdErr() {
        return StrictMath.sqrt(this.getMeanSquareError() / this.SSxx);
    }

    public double getInterceptStdErr() {
        return this.getYStdErr(0.0);
    }

    public double getYStdErr(double x) {
        return StrictMath.sqrt(this.getMeanSquareError() * (1.0 / (double)this.n + (x - this.xbar) * (x - this.xbar) / this.SSxx));
    }

    public double[] getSlopeConfidenceInterval() throws MathException {
        return this.getSlopeConfidenceInterval(0.05);
    }

    public abstract double[] getSlopeConfidenceInterval(double var1) throws MathException;

    public double[] getInterceptConfidenceInterval() throws MathException {
        return this.getInterceptConfidenceInterval(0.05);
    }

    public double[] getInterceptConfidenceInterval(double alpha) throws MathException {
        if (alpha >= 1.0 || alpha <= 0.0) {
            throw new IllegalArgumentException();
        }
        double[] CI = new double[2];
        if (!Double.isNaN(this.Y)) {
            CI[1] = 0.0;
            CI[0] = 0.0;
            return CI;
        }
        double a = this.getIntercept();
        double t = this.getInterceptStdErr() * this.getTDistribution().inverseCumulativeProbability(1.0 - alpha / 2.0);
        CI[0] = a - t;
        CI[1] = a + t;
        return CI;
    }

    public abstract double[] getYConfidenceInterval(double var1, double var3) throws MathException;

    public abstract double[] predict(double var1, double var3);

    public double[][] predict(double[][] values) {
        double[][] predicted = new double[values.length][values[0].length];
        for (int x = 0; x < values.length; ++x) {
            double[] temp = this.predict(values[x][0], values[x][1]);
            predicted[x][0] = temp[0];
            predicted[x][1] = temp[1];
        }
        return predicted;
    }

    public double[] getResidual(double x, double y) {
        double[] residual = this.predict(x, y);
        residual[0] = x - residual[0];
        residual[1] = y - residual[1];
        return residual;
    }

    public double[][] getResiduals(double[][] values) {
        double[][] residual = new double[values.length][values[0].length];
        for (int x = 0; x < values.length; ++x) {
            double[] temp = this.getResidual(values[x][0], values[x][1]);
            residual[x][0] = temp[0];
            residual[x][1] = temp[1];
        }
        return residual;
    }

    @Override
    public double getSignificance() throws MathException {
        return this.getAgainstOtherSlopeSignificance(0.0);
    }

    public double getAgainstOtherSlopeSignificance(double otherSlope) throws MathException {
        return 2.0 * (1.0 - this.getTDistribution().cumulativeProbability(StrictMath.abs(this.getSlope() - otherSlope) / this.getSlopeStdErr()));
    }

    public double getInterceptSignificance() throws MathException {
        if (!Double.isNaN(this.Y)) {
            return 1.0;
        }
        return 2.0 * (1.0 - this.getTDistribution().cumulativeProbability(StrictMath.abs(this.getIntercept()) / this.getInterceptStdErr()));
    }

    protected double getIntercept(double slope) {
        if (Double.isNaN(this.Y)) {
            return this.ybar - slope * this.xbar;
        }
        return this.Y - slope * this.X;
    }

    public void noIntercept(boolean status) {
        if (status) {
            this.setPoint(0.0, 0.0);
        } else {
            this.setPoint(0.0, Double.NaN);
        }
    }

    public void setIntercept(double intercept) {
        this.setPoint(0.0, intercept);
    }

    public void setPoint(double x, double y) {
        double yValue;
        double xValue;
        this.Y = y;
        this.X = x;
        if (Double.isNaN(this.zeroSSxx)) {
            this.zeroSSxx = this.SSxx + (double)this.n * this.xbar * this.xbar;
            this.zeroSSyy = this.SSyy + (double)this.n * this.ybar * this.ybar;
            this.zeroSSxy = this.SSxy + (double)this.n * this.xbar * this.ybar;
        }
        if (Double.isNaN(this.Y)) {
            xValue = this.xbar;
            yValue = this.ybar;
            this.df = this.n - 2L;
        } else {
            xValue = x;
            yValue = y;
            this.df = this.n - 1L;
        }
        this.SSxx = this.zeroSSxx - 2.0 * (double)this.n * this.xbar * xValue + (double)this.n * xValue * xValue;
        this.SSyy = this.zeroSSyy - 2.0 * (double)this.n * this.ybar * yValue + (double)this.n * yValue * yValue;
        this.SSxy = this.zeroSSxy - (double)this.n * this.xbar * xValue - (double)this.n * this.ybar * yValue + (double)this.n * yValue * xValue;
    }

    @Override
    public double getR() {
        return (this.getSlope() < 1.0 ? -1.0 : 1.0) * StrictMath.sqrt(this.getRSquare());
    }

    @Override
    public double getRSquare() {
        return this.getSumOfSquaresModel() / this.getSumOfSquaresTotal();
    }
}

