/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.regression;

import commonSense.math.MathException;
import commonSense.stats.descriptive.moment.Covariance;
import commonSense.stats.distribution.DistributionFactory;
import commonSense.stats.distribution.TDistribution;
import java.io.Serializable;

public class Correlation
extends Covariance
implements Serializable {
    static final long serialVersionUID = -3004689053607543335L;
    public double SSxx = 0.0;
    public double SSyy = 0.0;
    protected long df = 0L;

    @Override
    public void increment(double x, double y) {
        ++this.n;
        this.df = this.n - 2L;
        if (this.n == 1L) {
            this.xbar = x;
            this.ybar = y;
        } else {
            double dx = x - this.xbar;
            double dy = y - this.ybar;
            this.SSxx += dx * dx * ((double)this.n - 1.0) / (double)this.n;
            this.SSyy += dy * dy * ((double)this.n - 1.0) / (double)this.n;
            this.SSxy += dx * dy * ((double)this.n - 1.0) / (double)this.n;
            this.xbar += dx / (double)this.n;
            this.ybar += dy / (double)this.n;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.SSxx = 0.0;
        this.SSyy = 0.0;
        this.df = 0L;
    }

    public double[] getMeans() {
        double[] means = new double[]{this.xbar, this.ybar};
        return means;
    }

    public double getSignificance() throws MathException {
        double r = this.getR();
        double t = r * (Math.sqrt(this.getN() - 2L) / Math.sqrt(1.0 - r * r));
        return 2.0 * (1.0 - this.getTDistribution().cumulativeProbability(t));
    }

    protected TDistribution getTDistribution() {
        return DistributionFactory.newInstance().createTDistribution(this.df);
    }

    public double getR() {
        return this.SSxy / Math.sqrt(this.SSxx * this.SSyy);
    }

    @Override
    public double getResult() {
        return this.getR();
    }

    public double getRSquare() {
        return this.getCorrelationCoefficient();
    }

    public double getCorrelationCoefficient() {
        return this.SSxy * this.SSxy / (this.SSxx * this.SSyy);
    }
}

