/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.multivariate.outliers;

import commonSense.math.basics.Factorial;
import commonSense.math.linear.Distances;
import commonSense.math.linear.InvalidMatrixException;
import commonSense.math.linear.Matrix;
import commonSense.stats.StatUtils;
import commonSense.stats.descriptive.matrix.CovarianceMatrix;
import commonSense.stats.descriptive.matrix.SpecialMatrices;
import commonSense.stats.multivariate.outliers.AllSubset;
import commonSense.stats.multivariate.outliers.RandomSubset;
import commonSense.stats.multivariate.outliers.Subset;

public class MVE {
    public static final int NON_ROBUST = 0;
    public static final int BEST_SUBSAMPLE = 1;
    public static final int MEDIAN = 2;
    public static final int INFLATED = 3;
    public static final int ROBUST = 4;
    public static final int BASE = 0;
    public static final int COVAR = 5;
    public static final int COVAR_INV = 10;
    public static final int CORREL = 15;
    protected int maxNoVariables = 30;
    protected int nvmax1 = this.maxNoVariables + 1;
    protected boolean verbose = false;
    protected Matrix baseMatrix;
    protected Matrix subMatrix;
    protected Matrix transientCovar;
    protected Matrix transientCovarInv;
    protected Matrix nonRobustCovar;
    protected Matrix inflatedCovar;
    protected Matrix bestDiffMatrix;
    protected Matrix bestCovar;
    protected Matrix robustCovar;
    protected CovarianceMatrix covar = new CovarianceMatrix();
    protected Matrix transientCorrel;
    protected Matrix bestCorrel;
    protected Matrix robustCorrel;
    protected double[] transientMeans;
    protected double[] nonRobustMeans;
    protected double[] bestMeans;
    protected double[] robustMeans;
    protected double det;
    protected double[] robustDist;
    protected double[] bestDist;
    protected double[] nonRobustDist;
    protected double[] transientDist;
    protected double medianDist;
    protected double bestMedianDist;
    protected double volume;
    protected double object = Double.MAX_VALUE;
    protected double cutoff = 0.0;
    protected int[] flag;
    protected int weight;
    protected int[] distIn;
    protected int nin = 0;
    protected int nrep;
    protected int[] inSubset;
    protected int singularCount = 0;
    protected double cnp = 0.0;
    protected int[] inbest;
    protected int countIn = 0;
    protected boolean all = false;
    protected int variables = 0;
    protected int cases = 0;
    protected double eps = 1.0E-11;
    private double[] chimed = new double[]{0.0, 0.454937, 1.38629, 2.36597, 3.3567, 4.35146, 5.34812, 6.34581, 7.34412, 8.34283, 9.34182, 10.34, 11.34, 12.34, 13.34, 14.34, 15.34, 16.34, 17.34, 18.34, 19.34, 20.34, 21.34, 22.34, 23.34, 24.34, 25.34, 26.34, 27.34, 28.34, 29.34, 30.34, 31.34, 32.34, 33.34, 34.34, 35.34, 36.34, 37.34, 38.34, 39.34, 40.34, 41.34, 42.34, 43.34, 44.34, 45.34, 46.34, 47.33, 48.33, 49.33};
    private double[] chi2 = new double[]{0.0, 5.02389, 7.37776, 9.3484, 11.1433, 12.8325, 14.4494, 16.0128, 17.5346, 19.0228, 20.4831, 21.92, 23.337, 24.736, 26.119, 27.488, 28.845, 30.191, 31.526, 32.852, 34.17, 35.479, 36.781, 38.076, 39.364, 40.646, 41.923, 43.194, 44.461, 45.722, 46.979, 48.232, 49.481, 50.725, 51.966, 53.203, 54.437, 55.668, 56.896, 58.12, 59.342, 60.561, 61.777, 62.99, 64.201, 65.41, 66.617, 67.821, 69.022, 70.222, 71.42};

    public MVE(Matrix a) {
        new MVE(a, false);
    }

    public MVE(Matrix a, boolean verbose) {
        this.baseMatrix = a;
        this.verbose = verbose;
        this.variables = a.getColumnDimension();
        if (this.variables > this.maxNoVariables) {
            return;
        }
        this.cases = a.getRowDimension();
        this.nonRobustEstimates(this.baseMatrix);
        this.subSampling();
        this.finalisations();
    }

    private int[] subSampling() {
        this.singularCount = 0;
        int noSelected = this.variables + 1;
        this.nrep = this.replicas(noSelected, this.cases);
        Subset subset = this.all ? new AllSubset(this.cases, noSelected) : new RandomSubset(this.cases, noSelected);
        this.inbest = new int[noSelected];
        Matrix diffMatrix = new Matrix(this.cases, this.variables);
        double[][] diffArray = diffMatrix.getDataRef();
        double[][] baseArray = this.baseMatrix.getDataRef();
        this.bestDist = new double[this.cases];
        boolean isSingular = false;
        for (int i = 0; i < this.nrep; ++i) {
            int j;
            int[] index = subset.next();
            for (j = 0; j < noSelected; ++j) {
                this.verbose(false, index[j] + "\t");
            }
            this.subMatrix = this.baseMatrix.getSubMatrix(index, 0, this.variables - 1);
            this.transientCovar = this.covar.evaluate(this.subMatrix);
            this.transientMeans = this.subMatrix.columnMeans();
            for (j = 0; j < 2; ++j) {
                this.verbose(false, this.transientMeans[j] + "\t");
            }
            try {
                int x;
                for (x = 0; x < this.cases; ++x) {
                    for (int y = 0; y < this.variables; ++y) {
                        diffArray[x][y] = baseArray[x][y] - this.transientMeans[y];
                    }
                }
                this.transientDist = Distances.mahalanobis(diffMatrix, this.transientCovar);
                if (this.transientDist == null) continue;
                this.medianDist = StatUtils.percentile(this.transientDist, 50.0);
                this.det = this.transientCovar.getDeterminant();
                this.volume = Math.sqrt(Math.pow(this.medianDist, 2 * this.variables) * this.det);
                if (!(this.volume < this.object)) continue;
                this.verbose(true, "New best Median dist: " + this.medianDist + " and volume: " + this.volume);
                this.bestMedianDist = this.medianDist;
                this.object = this.volume;
                for (x = 0; x < noSelected; ++x) {
                    this.inbest[x] = index[x];
                }
                for (x = 0; x < this.transientDist.length; ++x) {
                    this.bestDist[x] = this.transientDist[x];
                    if (!(this.transientDist[x] < this.medianDist)) continue;
                    ++this.countIn;
                }
                this.bestCovar = this.transientCovar.copy();
                this.bestMeans = this.subMatrix.columnMeans();
                this.bestDiffMatrix = diffMatrix.copy();
                continue;
            }
            catch (InvalidMatrixException ime) {
                System.out.println("Simgular matrix!");
                ++this.singularCount;
            }
        }
        this.verbose(true, "");
        this.verbose(true, "The best subset");
        for (int j = 0; j < noSelected; ++j) {
            this.verbose(false, this.inbest[j] + "\t");
        }
        this.verbose(true, "\nMedian distance: " + this.bestMedianDist);
        return this.inbest;
    }

    private void finalisations() {
        this.cnp = 1.0 + 15.0 / ((double)(this.cases - this.variables) * 1.0);
        double correctionfactor = this.cnp * this.cnp * this.bestMedianDist / this.chimed[this.variables];
        this.inflatedCovar = this.bestCovar.scalarMultiply(correctionfactor);
        this.robustDist = Distances.mahalanobis(this.bestDiffMatrix, this.inflatedCovar);
        this.nin = 0;
        this.cutoff = this.chi2[this.variables];
        this.distIn = new int[this.cases];
        for (int i = 0; i < this.cases; ++i) {
            this.distIn[i] = 0;
            if (!(this.robustDist[i] <= this.cutoff)) continue;
            ++this.nin;
            this.distIn[i] = 1;
        }
        this.inSubset = new int[this.nin];
        int ninCount = 0;
        for (int i = 0; i < this.cases; ++i) {
            if (this.distIn[i] != 1) continue;
            this.inSubset[ninCount] = i;
            ++ninCount;
        }
        Matrix robustSubMatrix = this.baseMatrix.getSubMatrix(this.inSubset, 0, this.variables - 1);
        this.robustCovar = this.covar.evaluate(robustSubMatrix);
        this.robustMeans = robustSubMatrix.columnMeans();
    }

    protected void nonRobustEstimates(Matrix a) {
        this.nonRobustMeans = a.columnMeans();
        this.nonRobustCovar = this.covar.evaluate(a);
        Matrix b = SpecialMatrices.differenceByColumnMeans(a);
        this.nonRobustDist = Distances.mahalanobis(b, this.nonRobustCovar);
    }

    public int[] getOutliers() {
        return this.distIn;
    }

    public int outlierCount() {
        return this.cases - this.nin;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public double getMedianDistance() {
        return this.bestMedianDist;
    }

    public int[] getBestSubset() {
        return this.inbest;
    }

    public double getCorrection() {
        return this.cnp;
    }

    public double[] getDistances(int robustness) {
        if (robustness == 0) {
            if (this.nonRobustDist == null) {
                this.nonRobustEstimates(this.baseMatrix);
            }
            return this.nonRobustDist;
        }
        if (robustness == 4) {
            if (this.robustDist == null) {
                this.subSampling();
                this.finalisations();
            }
            return this.robustDist;
        }
        return null;
    }

    public double[] getMeans(int robustness) {
        if (robustness == 0) {
            if (this.nonRobustMeans == null) {
                return this.baseMatrix.columnMeans();
            }
            return this.nonRobustMeans;
        }
        if (robustness == 4) {
            if (this.robustMeans == null) {
                this.subSampling();
                this.finalisations();
            }
            return this.robustMeans;
        }
        if (robustness == 1) {
            if (this.robustMeans == null) {
                this.subSampling();
                this.finalisations();
            }
            return this.bestMeans;
        }
        return null;
    }

    public Matrix getMatrix(int robustness, int type) {
        int sum = robustness + type;
        switch (sum) {
            case 0: {
                return this.baseMatrix;
            }
            case 1: {
                return this.subMatrix;
            }
            case 5: {
                return this.nonRobustCovar;
            }
            case 6: {
                return this.bestCovar;
            }
            case 7: {
                return this.bestCovar.scalarMultiply(this.bestMedianDist);
            }
            case 8: {
                return this.inflatedCovar;
            }
            case 9: {
                return this.robustCovar;
            }
            case 10: {
                return this.nonRobustCovar.inverse();
            }
            case 11: {
                return this.bestCovar.inverse();
            }
            case 12: {
                return this.bestCovar.scalarMultiply(this.bestMedianDist).inverse();
            }
            case 13: {
                return this.inflatedCovar.inverse();
            }
            case 14: {
                return this.robustCovar.inverse();
            }
            case 15: {
                return SpecialMatrices.correl(this.nonRobustCovar, true);
            }
            case 16: {
                return SpecialMatrices.correl(this.bestCovar, true);
            }
            case 17: {
                return SpecialMatrices.correl(this.bestCovar.scalarMultiply(this.bestMedianDist), true);
            }
            case 18: {
                return SpecialMatrices.correl(this.inflatedCovar, true);
            }
            case 19: {
                return SpecialMatrices.correl(this.robustCovar, true);
            }
        }
        return null;
    }

    private double findq(double[] aw, int k) {
        int l = 1;
        int lr = aw.length;
        if (l < lr) {
            double ax = aw[k];
            int jnc = l;
            int j = lr;
            if (jnc <= j) {
                if (aw[jnc] < ax) {
                    ++jnc;
                }
                if (aw[j] > ax) {
                    --j;
                }
                if (jnc < j) {
                    double wa = aw[jnc];
                    aw[jnc] = aw[j];
                    aw[j] = wa;
                    ++jnc;
                    --j;
                }
            }
            if (j < k) {
                l = jnc;
            }
            if (k < jnc) {
                lr = j;
            }
        }
        double findq = aw[k];
        return findq;
    }

    private void exitError(String s) {
        this.verbose(true, s);
        System.exit(1000);
    }

    private void verbose(boolean endOfLine, String s) {
        if (this.verbose) {
            if (endOfLine) {
                System.out.println(s);
            } else {
                System.out.print(s);
            }
        }
    }

    private int replicas(int noSelected, int cases) {
        int[] replow = new int[]{500, 50, 22, 17, 15, 14};
        this.nrep = 0;
        if (cases < (noSelected > 6 ? 0 : replow[noSelected - 1])) {
            this.all = true;
            this.nrep = noSelected == 1 ? cases : Factorial.simplify(cases, noSelected);
        } else {
            this.all = false;
            this.nrep = noSelected > 5 ? 3000 : 500 * noSelected;
        }
        return this.nrep;
    }

    public void setMaxNoVariable(int maxNoVariables) {
        this.maxNoVariables = maxNoVariables;
    }

    public int noReplications() {
        return this.nrep;
    }

    public int singularCount() {
        return this.singularCount;
    }
}

