/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.multivariate;

import commonSense.math.linear.EigenvalueDecomposition;
import commonSense.math.linear.Matrix;
import commonSense.stats.descriptive.matrix.SpecialMatrices;

public class PCA {
    EigenvalueDecomposition eigen;
    Matrix X;
    Matrix Z;
    Matrix V;
    Matrix F;
    Matrix R;
    Matrix D;
    Matrix sqrtD;
    Matrix sqrtDReciprocal;
    Matrix B;
    double[] eigenvalues;
    public static final int SAMPLE_COVAR = 0;
    public static final int POPULATION_COVAR = 1;
    public static final int CORREL = 2;
    static boolean verbose = false;
    static double[][] testMatrix = new double[][]{{7.0, 4.0, 3.0}, {4.0, 1.0, 8.0}, {6.0, 3.0, 5.0}, {8.0, 6.0, 1.0}, {8.0, 5.0, 7.0}, {7.0, 2.0, 9.0}, {5.0, 3.0, 3.0}, {9.0, 5.0, 8.0}, {7.0, 4.0, 5.0}, {8.0, 2.0, 2.0}};

    public PCA(Matrix X, int type) {
        this.X = X;
        if (type == 2) {
            this.R = SpecialMatrices.correl(X, false);
            this.Z = SpecialMatrices.standardisedByColumns(X, 1);
        } else if (type == 1) {
            this.R = SpecialMatrices.covar(X, true);
            this.Z = SpecialMatrices.differenceByColumnMeans(X);
        } else if (type == 0) {
            this.R = SpecialMatrices.covar(X, false);
            this.Z = SpecialMatrices.differenceByColumnMeans(X);
        } else {
            throw new IllegalArgumentException("Type value (" + type + ") is out of range (0, 1, 2)");
        }
        this.eigen = new EigenvalueDecomposition(this.R);
        this.flip();
        this.LMatrices();
        this.B = this.V.multiply(this.sqrtDReciprocal);
        this.F = this.Z.multiply(this.B);
        if (verbose) {
            this.printOut();
        }
    }

    public Matrix getFactorScores() {
        return this.F;
    }

    public Matrix getEigenvalueMatrix() {
        return this.D;
    }

    public double[] getEigenvalues() {
        return this.eigenvalues;
    }

    public int noPositiveEigenvalues() {
        int no = 0;
        for (int x = 0; x < this.eigenvalues.length; ++x) {
            if (!(this.eigenvalues[x] > 1.0E-14)) continue;
            ++no;
        }
        System.out.println("Valid eigenvalues: " + no);
        return no;
    }

    public Matrix getEigenvectorMatrix() {
        return this.V;
    }

    public Matrix getCoefficientMatrix() {
        return this.B;
    }

    public Matrix getCorrelationMatrix() {
        return this.R;
    }

    private void flip() {
        double[][] v = this.eigen.getV().getDataRef();
        double[][] d = this.eigen.getD().getDataRef();
        double[] e = this.eigen.getRealEigenvalues();
        int dim = e.length;
        int max = dim - 1;
        double[][] vnew = new double[dim][dim];
        double[][] dnew = new double[dim][dim];
        this.eigenvalues = new double[dim];
        for (int x = 0; x < dim; ++x) {
            for (int y = 0; y < dim; ++y) {
                vnew[x][y] = v[x][max - y];
                dnew[x][y] = d[max - x][max - y];
            }
            this.eigenvalues[x] = e[max - x];
        }
        this.V = new Matrix(vnew);
        this.D = new Matrix(dnew);
    }

    private final void LMatrices() {
        int dim = this.eigenvalues.length;
        double[][] sqrt = new double[dim][dim];
        double[][] sqrtRec = new double[dim][dim];
        for (int x = 0; x < dim; ++x) {
            for (int y = 0; y < dim; ++y) {
                sqrt[x][y] = 0.0;
                sqrtRec[x][y] = 0.0;
            }
            sqrt[x][x] = Math.sqrt(this.eigenvalues[x]);
            sqrtRec[x][x] = 1.0 / sqrt[x][x];
        }
        this.sqrtD = new Matrix(sqrt);
        this.sqrtDReciprocal = new Matrix(sqrtRec);
    }

    public static void main(String[] args) {
        verbose = true;
        PCA pca = new PCA(new Matrix(testMatrix), 1);
    }

    public void printOut() {
        System.out.println("BaseMatrix:\n" + this.X.toSquareString());
        System.out.println("Correl:\n" + this.R.toSquareString());
        System.out.println("EigenVectors:\n" + this.V.toSquareString());
        System.out.println("Factor coordianets:\n" + this.D.toSquareString());
        System.out.println("L half:\n" + this.sqrtD.toSquareString());
        System.out.println("rciprocal L half:\n" + this.sqrtDReciprocal.toSquareString());
        System.out.println("B:\n" + this.B.toSquareString());
        System.out.println("Z:\n" + this.Z.toSquareString());
        System.out.println("F:\n" + this.F.toSquareString());
    }
}

