/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Beta;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public class TDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -5852615386664158222L;
    private double degreesOfFreedom;

    public TDistribution(double degreesOfFreedom) {
        this.setDegreesOfFreedom(degreesOfFreedom);
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x == 0.0) {
            ret = 0.5;
        } else {
            double t = Beta.regularizedBeta(this.getDegreesOfFreedom() / (this.getDegreesOfFreedom() + x * x), 0.5 * this.getDegreesOfFreedom(), 0.5);
            ret = x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    @Override
    protected double getDomainLowerBound(double p) {
        return -1.7976931348623157E308;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double p) {
        return 0.0;
    }
}

