/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Erf;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public class NormalDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = 8589540077390120676L;
    private double mean = 0.0;
    private double standardDeviation = 1.0;

    public NormalDistribution(double mean, double sd) {
        this.setMean(mean);
        this.setStandardDeviation(sd);
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double sd) {
        if (sd <= 0.0) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = sd;
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        return 0.5 * (1.0 + Erf.erf((x - this.mean) / (this.standardDeviation * Math.sqrt(2.0))));
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    @Override
    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.getMean();
        return ret;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getMean() : Double.MAX_VALUE;
        return ret;
    }

    @Override
    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getMean() - this.getStandardDeviation() : (p > 0.5 ? this.getMean() + this.getStandardDeviation() : this.getMean());
        return ret;
    }
}

