/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.util.MathUtils;
import commonSense.stats.distribution.AbstractIntegerDistribution;
import commonSense.stats.distribution.IntegerDistribution;
import java.io.Serializable;

public class HypergeometricDistribution
extends AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistribution(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (numberOfSuccesses > populationSize) {
            throw new IllegalArgumentException("number of successes must be less than or equal to population size");
        }
        if (sampleSize > populationSize) {
            throw new IllegalArgumentException("sample size must be less than or equal to population size");
        }
        this.setPopulationSize(populationSize);
        this.setSampleSize(sampleSize);
        this.setNumberOfSuccesses(numberOfSuccesses);
    }

    @Override
    public double cumulativeProbability(int x) throws MathException {
        double ret;
        int k;
        int m;
        int n = this.getPopulationSize();
        int[] domain = this.getDomain(n, m = this.getNumberOfSuccesses(), k = this.getSampleSize());
        if (x < domain[0]) {
            ret = 0.0;
        } else if (x >= domain[1]) {
            ret = 1.0;
        } else {
            ret = 0.0;
            for (int i = domain[0]; i <= x; ++i) {
                ret += this.probability(n, m, k, i);
            }
        }
        return ret;
    }

    private int[] getDomain(int n, int m, int k) {
        return new int[]{this.getLowerDomain(n, m, k), this.getUpperDomain(m, k)};
    }

    @Override
    protected int getDomainLowerBound(double p) {
        return this.getLowerDomain(this.getPopulationSize(), this.getNumberOfSuccesses(), this.getSampleSize());
    }

    @Override
    protected int getDomainUpperBound(double p) {
        return this.getUpperDomain(this.getSampleSize(), this.getNumberOfSuccesses());
    }

    private int getLowerDomain(int n, int m, int k) {
        return Math.max(0, m - (n - k));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m, int k) {
        return Math.min(k, m);
    }

    @Override
    public double probability(int x) {
        int k;
        int m;
        int n = this.getPopulationSize();
        int[] domain = this.getDomain(n, m = this.getNumberOfSuccesses(), k = this.getSampleSize());
        double ret = x < domain[0] || x > domain[1] ? 0.0 : this.probability(n, m, k, x);
        return ret;
    }

    private double probability(int n, int m, int k, int x) {
        return Math.exp(MathUtils.binomialCoefficientLog(m, x) + MathUtils.binomialCoefficientLog(n - m, k - x) - MathUtils.binomialCoefficientLog(n, k));
    }

    public void setNumberOfSuccesses(int num) {
        if (num < 0) {
            throw new IllegalArgumentException("number of successes must be non-negative.");
        }
        this.numberOfSuccesses = num;
    }

    public void setPopulationSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("population size must be positive.");
        }
        this.populationSize = size;
    }

    public void setSampleSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("sample size must be non-negative.");
        }
        this.sampleSize = size;
    }
}

