/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Beta;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public class FDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -8516354193418641566L;
    private double numeratorDegreesOfFreedom;
    private double denominatorDegreesOfFreedom;

    public FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        this.setNumeratorDegreesOfFreedom(numeratorDegreesOfFreedom);
        this.setDenominatorDegreesOfFreedom(denominatorDegreesOfFreedom);
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x <= 0.0) {
            ret = 0.0;
        } else {
            double n = this.getNumeratorDegreesOfFreedom();
            double m = this.getDenominatorDegreesOfFreedom();
            ret = Beta.regularizedBeta(n * x / (m + n * x), 0.5 * n, 0.5 * m);
        }
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    @Override
    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double p) {
        return this.getDenominatorDegreesOfFreedom() / (this.getDenominatorDegreesOfFreedom() - 2.0);
    }

    public void setNumeratorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.numeratorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public void setDenominatorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.denominatorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }
}

