/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import commonSense.stats.distribution.DistributionFactory;
import commonSense.stats.distribution.GammaDistribution;
import java.io.Serializable;

public class ChiSquaredDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -8352658048349159782L;
    private GammaDistribution gamma;

    public ChiSquaredDistribution(double degreesOfFreedom) {
        this.setGamma(DistributionFactory.newInstance().createGammaDistribution(degreesOfFreedom / 2.0, 2.0));
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.getGamma().setAlpha(degreesOfFreedom / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.getGamma().getAlpha() * 2.0;
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        return this.getGamma().cumulativeProbability(x);
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    @Override
    protected double getDomainLowerBound(double p) {
        return Double.MIN_VALUE * this.getGamma().getBeta();
    }

    @Override
    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getDegreesOfFreedom() : Double.MAX_VALUE;
        return ret;
    }

    @Override
    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getDegreesOfFreedom() * 0.5 : this.getDegreesOfFreedom();
        return ret;
    }

    private void setGamma(GammaDistribution gamma) {
        this.gamma = gamma;
    }

    private GammaDistribution getGamma() {
        return this.gamma;
    }
}

