/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Beta;
import commonSense.math.util.MathUtils;
import commonSense.stats.distribution.AbstractIntegerDistribution;
import commonSense.stats.distribution.IntegerDistribution;
import java.io.Serializable;

public class BinomialDistribution
extends AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistribution(int trials, double p) {
        this.setNumberOfTrials(trials);
        this.setProbabilityOfSuccess(p);
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public void setNumberOfTrials(int trials) {
        if (trials < 0) {
            throw new IllegalArgumentException("number of trials must be non-negative.");
        }
        this.numberOfTrials = trials;
    }

    public void setProbabilityOfSuccess(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability of success must be between 0.0 and 1.0, inclusive.");
        }
        this.probabilityOfSuccess = p;
    }

    @Override
    protected int getDomainLowerBound(double p) {
        return -1;
    }

    @Override
    protected int getDomainUpperBound(double p) {
        return this.getNumberOfTrials();
    }

    @Override
    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : (x >= this.getNumberOfTrials() ? 1.0 : 1.0 - Beta.regularizedBeta(this.getProbabilityOfSuccess(), (double)x + 1.0, this.getNumberOfTrials() - x));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 || x > this.getNumberOfTrials() ? 0.0 : MathUtils.binomialCoefficientDouble(this.getNumberOfTrials(), x) * Math.pow(this.getProbabilityOfSuccess(), x) * Math.pow(1.0 - this.getProbabilityOfSuccess(), this.getNumberOfTrials() - x);
        return ret;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return -1;
        }
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(p);
    }
}

