/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.ConvergenceException;
import commonSense.math.FunctionEvaluationException;
import commonSense.math.MathException;
import commonSense.math.analysis.UnivariateRealFunction;
import commonSense.math.analysis.UnivariateRealSolverUtils;
import commonSense.stats.distribution.AbstractDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public abstract class AbstractContinuousDistribution
extends AbstractDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -38038050983108802L;

    protected AbstractContinuousDistribution() {
    }

    @Override
    public double inverseCumulativeProbability(final double p) throws MathException {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0.0 and 1.0, inclusive.");
        }
        UnivariateRealFunction rootFindingFunction = new UnivariateRealFunction(){

            @Override
            public double value(double x) throws FunctionEvaluationException {
                try {
                    return AbstractContinuousDistribution.this.cumulativeProbability(x) - p;
                }
                catch (MathException ex) {
                    throw new FunctionEvaluationException(x, "Error computing cdf", ex);
                }
            }
        };
        double lowerBound = this.getDomainLowerBound(p);
        double upperBound = this.getDomainUpperBound(p);
        double[] bracket = null;
        try {
            bracket = UnivariateRealSolverUtils.bracket(rootFindingFunction, this.getInitialDomain(p), lowerBound, upperBound);
        }
        catch (ConvergenceException ex) {
            if (Math.abs(rootFindingFunction.value(lowerBound)) < 1.0E-6) {
                return lowerBound;
            }
            if (Math.abs(rootFindingFunction.value(upperBound)) < 1.0E-6) {
                return upperBound;
            }
            throw new MathException(ex);
        }
        double root = UnivariateRealSolverUtils.solve(rootFindingFunction, bracket[0], bracket[1]);
        return root;
    }

    protected abstract double getInitialDomain(double var1);

    protected abstract double getDomainLowerBound(double var1);

    protected abstract double getDomainUpperBound(double var1);
}

