/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.summary;

import commonSense.stats.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    static final long serialVersionUID = -370076995648386763L;
    private int n = 0;
    private double value = 0.0;

    @Override
    public void increment(double d) {
        this.value += Math.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        if (this.n > 0) {
            return this.value;
        }
        return Double.NaN;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double sumLog = Double.NaN;
        if (this.test(values, begin, length)) {
            sumLog = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumLog += Math.log(values[i]);
            }
        }
        return sumLog;
    }
}

