/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.rank;

import commonSense.stats.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;

public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    static final long serialVersionUID = -2941995784909003131L;
    private long n = 0L;
    private double value = Double.NaN;

    @Override
    public void increment(double d) {
        if (d < this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double min = Double.NaN;
        if (this.test(values, begin, length)) {
            min = values[begin];
            for (int i = begin; i < begin + length; ++i) {
                if (Double.isNaN(values[i])) continue;
                min = min < values[i] ? min : values[i];
            }
        }
        return min;
    }
}

