/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.moment;

import commonSense.stats.descriptive.AbstractStorelessUnivariateStatistic;
import commonSense.stats.descriptive.summary.SumOfLogs;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic {
    static final long serialVersionUID = -8178734905303459453L;
    private SumOfLogs sumOfLogs = new SumOfLogs();

    @Override
    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    @Override
    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return Math.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        this.sumOfLogs.clear();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        return Math.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    @Override
    public long getN() {
        return this.sumOfLogs.getN();
    }
}

