/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.moment;

import commonSense.stats.descriptive.AbstractStorelessBivariateStatistic;

public class Covariance
extends AbstractStorelessBivariateStatistic {
    public double SSxy = 0.0;
    protected long n = 0L;
    protected double xbar = 0.0;
    protected double ybar = 0.0;
    private boolean isBiasCorrected = false;

    public Covariance() {
    }

    public Covariance(boolean isBiasCorrected) {
        this.isBiasCorrected = isBiasCorrected;
    }

    @Override
    public void increment(double x, double y) {
        ++this.n;
        if (this.n == 1L) {
            this.xbar = x;
            this.ybar = y;
        } else {
            double dx = x - this.xbar;
            double dy = y - this.ybar;
            this.SSxy += dx * dy * ((double)this.n - 1.0) / (double)this.n;
            this.xbar += dx / (double)this.n;
            this.ybar += dy / (double)this.n;
        }
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.SSxy = 0.0;
        this.n = 0L;
        this.xbar = 0.0;
        this.ybar = 0.0;
    }

    @Override
    public double getResult() {
        return this.SSxy / (double)this.n;
    }
}

