/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.matrix;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.MatrixIndexException;
import commonSense.stats.descriptive.matrix.SSCPMatrix;

public class SpecialMatrices {
    private SpecialMatrices() {
    }

    public static Matrix SSCP(Matrix a) {
        return new SSCPMatrix().evaluate(a);
    }

    public static Matrix differenceByColumnMeans(Matrix a) {
        double[] means = a.columnMeans();
        return SpecialMatrices.columnWiseResiduals(a, means);
    }

    public static Matrix columnWiseResiduals(Matrix a, double[] means) throws MatrixIndexException {
        int rowCount = a.getRowDimension();
        int columnCount = a.getColumnDimension();
        if (columnCount != means.length) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        Matrix X = new Matrix(rowCount, columnCount);
        double[][] B = X.getDataRef();
        double[][] A = a.getData();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                B[i][j] = A[i][j] - means[j];
            }
        }
        return new Matrix(B);
    }

    public static Matrix standardisedByColumns(Matrix a, int type) {
        int rowCount = a.getRowDimension();
        int columnCount = a.getColumnDimension();
        double[] means = a.columnMeans();
        double[] SDs = a.columnSDs(type);
        Matrix X = new Matrix(rowCount, columnCount);
        double[][] B = X.getDataRef();
        double[][] A = a.getData();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                B[i][j] = (A[i][j] - means[j]) / SDs[j];
            }
        }
        return new Matrix(B);
    }

    public static Matrix differenceByRowMeans(Matrix a) {
        int rowCount = a.getRowDimension();
        int columnCount = a.getColumnDimension();
        double[] means = a.rowMeans();
        Matrix X = new Matrix(rowCount, columnCount);
        double[][] B = X.getDataRef();
        double[][] A = a.getData();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                B[i][j] = A[i][j] - means[i];
            }
        }
        return X;
    }

    public static Matrix covar(Matrix a, boolean type) {
        int rows = a.getRowDimension();
        Matrix dif = SpecialMatrices.differenceByColumnMeans(a);
        if (type) {
            return dif.transpose().multiply(dif).scalarMultiply(1.0 / ((double)rows - 1.0));
        }
        return dif.transpose().multiply(dif).scalarMultiply(1.0 / (double)rows);
    }

    public static Matrix covar(Matrix a) {
        return SpecialMatrices.covar(a, true);
    }

    public static Matrix correl(Matrix a, boolean covariance) {
        double[][] covar = covariance ? a.getData() : SpecialMatrices.covar(a, false).getData();
        int cols = covar[0].length;
        Matrix correl = new Matrix(cols, cols);
        double[][] correlArray = correl.getDataRef();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < cols; ++row) {
                correlArray[col][row] = covar[col][row] / StrictMath.sqrt(covar[col][col] * covar[row][row]);
            }
        }
        return correl;
    }
}

