/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive;

import commonSense.DifferentArrayLengthException;
import commonSense.stats.descriptive.BivariateStatistic;
import java.io.Serializable;

public abstract class AbstractBivariateStatistic
implements BivariateStatistic,
Serializable {
    static final long serialVersionUID = -8007759382851708045L;

    @Override
    public double evaluate(double[][] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public double evaluate(double[] xValues, double[] yValues) {
        this.test(xValues, yValues, 0, 0);
        return this.evaluate(xValues, yValues, 0, xValues.length);
    }

    @Override
    public abstract double evaluate(double[][] var1, int var2, int var3);

    @Override
    public abstract double evaluate(double[] var1, double[] var2, int var3, int var4);

    protected boolean test(double[][] values, int begin, int length) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (begin < 0) {
            throw new IllegalArgumentException("start position cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (begin + length > values.length) {
            throw new IllegalArgumentException("begin + length > values.length");
        }
        return length != 0;
    }

    protected boolean test(double[] xValues, double[] yValues, int begin, int length) {
        if (xValues == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (yValues == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (xValues.length != yValues.length) {
            throw new DifferentArrayLengthException("arrays are of different length");
        }
        if (begin < 0) {
            throw new IllegalArgumentException("start position cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (begin + length > xValues.length) {
            throw new IllegalArgumentException("begin + length > values.length");
        }
        return length != 0;
    }
}

