/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.GeneralizedProcrustes;
import commonSense.stats.StatUtils;

public class GeneralizedResistantFit
extends GeneralizedProcrustes {
    public GeneralizedResistantFit(Matrix[] cases, double tolerance) {
        this.center();
    }

    protected void commonScale() {
    }

    @Override
    protected void scale() {
        for (int i = 0; i < this.N; ++i) {
            this.preShape[i] = this.centered[i].scalarMultiply(1.0 / StatUtils.percentile(this.interLandmarkDistances(this.centered[i]), 50.0));
        }
    }

    public double[] interLandmarkDistances(Matrix m) {
        int rows = m.getRowDimension();
        double[] d = new double[rows - 1];
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            count = 0;
            for (int j = 0; j < rows; ++j) {
                if (i == j) continue;
                Matrix diff = m.getRowMatrix(i).subtract(m.getRowMatrix(j));
                d[count] = diff.multiply(diff.transpose()).getEntry(0, 0);
                ++count;
            }
        }
        return d;
    }
}

