/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.MathException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.DoubleGeneralizedProcrustes;

public class BooksteinCoordinates
extends DoubleGeneralizedProcrustes {
    protected BooksteinCoordinates() {
    }

    public BooksteinCoordinates(Matrix[] cases, int[] selectedLandmarks) throws MathException {
        this(cases, selectedLandmarks, 0.001, false);
    }

    public BooksteinCoordinates(Matrix[] cases, int[] selectedLandmarks, boolean maxVarianceRotation) throws MathException {
        this(cases, selectedLandmarks, 0.001, maxVarianceRotation);
    }

    public BooksteinCoordinates(Matrix[] cases, int[] selectedLandmarks, double tolerance) throws MathException {
        this(cases, selectedLandmarks, tolerance, false);
    }

    public BooksteinCoordinates(Matrix[] cases, int[] selectedLandmarks, double tolerance, boolean maxVarianceRotation) throws MathException {
        this.init(this.generateAnalysisMatrices(cases, selectedLandmarks), cases);
        this.center();
        this.scale();
        this.consensus = this.preShapeA[0];
        this.rotate();
        this.tolerance = tolerance;
        this.iteration();
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
    }

    protected Matrix[] generateAnalysisMatrices(Matrix[] cases, int[] selectedLandmarks) throws MathException {
        if (selectedLandmarks.length != 2) {
            throw new MathException("Bookstein coordinates needs exactly two points for the analysis");
        }
        Matrix[] analysis = new Matrix[cases.length];
        int end = cases[0].getRowDimension();
        for (int x = 0; x < cases.length; ++x) {
            analysis[x] = cases[x].getSubMatrix(0, end, selectedLandmarks);
        }
        return analysis;
    }
}

