/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.DifferentArrayLengthException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Procrustes;

public abstract class AbstractDoubleProcrustes
extends Procrustes {
    protected Matrix[] rawA;
    protected Matrix[] centeredA;
    protected Matrix[] preShapeA;
    protected Matrix[] shapeA;
    protected Matrix[] shapeSizeA;
    protected Matrix[] affineA;
    protected Matrix[] affineSizeA;
    protected Matrix[] uniformA;

    protected AbstractDoubleProcrustes() {
    }

    protected void init(Matrix[] alignmentCases, Matrix[] dataAnalysisCases) {
        if (alignmentCases.length != dataAnalysisCases.length) {
            throw new DifferentArrayLengthException("Matrices are of different length: " + alignmentCases.length + " versus " + dataAnalysisCases.length);
        }
        this.init(dataAnalysisCases);
        this.N = alignmentCases.length;
        this.rawA = alignmentCases;
        this.centeredA = new Matrix[this.N];
        this.preShapeA = new Matrix[this.N];
        this.shapeA = new Matrix[this.N];
        this.shapeSizeA = new Matrix[this.N];
    }

    @Override
    protected void center() {
        this.centeredA = AbstractDoubleProcrustes.center(this.rawA);
        for (int i = 0; i < this.N; ++i) {
            this.translation[i] = this.rawA[i].subtract(this.centeredA[i]);
            this.centered[i] = AbstractDoubleProcrustes.translate(this.raw[i], this.translation[i].getRow(0));
        }
    }

    protected void print(double[][] a) {
        System.out.println("Start Matrix");
        for (int x = 0; x < a.length; ++x) {
            for (int y = 0; y < a[0].length; ++y) {
                System.out.print(a[x][y] + " ");
            }
            System.out.println("");
        }
        System.out.println("End Matrix");
    }

    protected void print(Matrix a) {
        this.print(a.getData());
    }

    @Override
    protected void translate(double[] center) {
        this.centered = AbstractDoubleProcrustes.translate(this.raw, center);
        this.centeredA = AbstractDoubleProcrustes.translate(this.rawA, center);
    }

    public Matrix[] getCenteredAnalysisMatrices() {
        return this.copy(this.centeredA);
    }

    @Override
    protected void scale() {
        this.calculateCentroidSizes();
        for (int i = 0; i < this.N; ++i) {
            this.preShapeA[i] = AbstractDoubleProcrustes.scale(this.centeredA[i], this.centroidSize[i]);
            this.preShape[i] = AbstractDoubleProcrustes.scale(this.centered[i], this.centroidSize[i]);
        }
    }

    public Matrix[] getPreShapeAnalysisMatrices() {
        return this.copy(this.preShapeA);
    }

    protected void calculateCentroidSizes() {
        this.centroidSize = AbstractDoubleProcrustes.calculateCentroidSizes(this.centeredA);
    }

    @Override
    protected void rotate() {
        this.shapeA = AbstractDoubleProcrustes.rotateRef(this.preShapeA, this.consensus);
        this.shape = AbstractDoubleProcrustes.rotate(this.preShape, this.getRotationAnalysisMatrices());
    }

    public Matrix[] getShapeAnalysisMatrices() {
        return this.copy(this.shapeA);
    }

    public Matrix[] getRotationAnalysisMatrices() {
        return AbstractDoubleProcrustes.getRotationMatrices(this.preShapeA, this.consensus);
    }

    @Override
    protected void uniformShapeChange() {
        this.uniform = AbstractDoubleProcrustes.getUniformShapeChangeMatrices(this.shapeA, this.consensus);
        this.affine = AbstractDoubleProcrustes.uniformShapeChange(this.shape, this.uniform);
        this.affineA = AbstractDoubleProcrustes.uniformShapeChange(this.shapeA, this.uniform);
    }

    public Matrix[] getAffineAnalysisMatrices() {
        return this.copy(this.affineA);
    }

    @Override
    protected void restoreSize() {
        for (int i = 0; i < this.N; ++i) {
            this.shapeSize[i] = this.shape[i].scalarMultiply(this.centroidSize[i]);
            this.shapeSizeA[i] = this.shapeA[i].scalarMultiply(this.centroidSize[i]);
        }
    }

    public Matrix[] getShapeSizeAnalysisMatrices() {
        return this.copy(this.shapeSizeA);
    }

    public Matrix[] getAffineSizeAnalysisMatrices() {
        return this.copy(this.affineSizeA);
    }
}

