/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.math.linear.InvalidMatrixException;
import commonSense.math.linear.Matrix;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private double[] single;
    private int rows;
    private int columns;
    private double eps = Math.pow(2.0, -52.0);
    private double tiny = Math.pow(2.0, -966.0);

    public SingularValueDecomposition(Matrix Arg) {
        int i;
        double t;
        int k;
        int j;
        double[][] A = Arg.getData();
        this.rows = Arg.getRowDimension();
        this.columns = Arg.getColumnDimension();
        if (this.rows < this.columns) {
            throw new IllegalArgumentException("Jama SVD only works for rows >= columns");
        }
        int nu = Math.min(this.rows, this.columns);
        this.single = new double[Math.min(this.rows + 1, this.columns)];
        this.U = new double[this.rows][nu];
        this.V = new double[this.columns][this.columns];
        double[] e = new double[this.columns];
        double[] work = new double[this.rows];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.rows - 1, this.columns);
        int nrt = Math.max(0, Math.min(this.columns - 2, this.rows));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.single[k2] = 0.0;
                for (i3 = k2; i3 < this.rows; ++i3) {
                    this.single[k2] = StrictMath.hypot(this.single[k2], A[i3][k2]);
                }
                if (this.single[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.single[k2] = -this.single[k2];
                    }
                    for (i3 = k2; i3 < this.rows; ++i3) {
                        double[] dArray = A[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.single[k2];
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.single[k2] = -this.single[k2];
            }
            for (j = k2 + 1; j < this.columns; ++j) {
                if (k2 < nct & this.single[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i2 = k2; i2 < this.rows; ++i2) {
                        t2 += A[i2][k2] * A[i2][j];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (i2 = k2; i2 < this.rows; ++i2) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (i3 = k2; i3 < this.rows; ++i3) {
                    this.U[i3][k2] = A[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i3 = k2 + 1; i3 < this.columns; ++i3) {
                e[k2] = StrictMath.hypot(e[k2], e[i3]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i3 = k2 + 1;
                while (i3 < this.columns) {
                    int n = i3++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.rows & e[k2] != 0.0) {
                for (i3 = k2 + 1; i3 < this.rows; ++i3) {
                    work[i3] = 0.0;
                }
                for (j = k2 + 1; j < this.columns; ++j) {
                    for (int i4 = k2 + 1; i4 < this.rows; ++i4) {
                        int n = i4;
                        work[n] = work[n] + e[j] * A[i4][j];
                    }
                }
                for (j = k2 + 1; j < this.columns; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (i2 = k2 + 1; i2 < this.rows; ++i2) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * work[i2];
                    }
                }
            }
            if (!wantv) continue;
            for (i3 = k2 + 1; i3 < this.columns; ++i3) {
                this.V[i3][k2] = e[i3];
            }
        }
        int p = Math.min(this.columns, this.rows + 1);
        if (nct < this.columns) {
            this.single[nct] = A[nct][nct];
        }
        if (this.rows < p) {
            this.single[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int i5 = 0; i5 < this.rows; ++i5) {
                    this.U[i5][j] = 0.0;
                }
                this.U[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i6;
                if (this.single[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        t = 0.0;
                        for (i = k; i < this.rows; ++i) {
                            t += this.U[i][k] * this.U[i][j2];
                        }
                        t = -t / this.U[k][k];
                        for (i = k; i < this.rows; ++i) {
                            double[] dArray = this.U[i];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.U[i][k];
                        }
                    }
                    for (i6 = k; i6 < this.rows; ++i6) {
                        this.U[i6][k] = -this.U[i6][k];
                    }
                    this.U[k][k] = 1.0 + this.U[k][k];
                    for (i6 = 0; i6 < k - 1; ++i6) {
                        this.U[i6][k] = 0.0;
                    }
                    continue;
                }
                for (i6 = 0; i6 < this.rows; ++i6) {
                    this.U[i6][k] = 0.0;
                }
                this.U[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (k = this.columns - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        t = 0.0;
                        for (i = k + 1; i < this.columns; ++i) {
                            t += this.V[i][k] * this.V[i][j3];
                        }
                        t = -t / this.V[k + 1][k];
                        for (i = k + 1; i < this.columns; ++i) {
                            double[] dArray = this.V[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.V[i][k];
                        }
                    }
                }
                for (int i7 = 0; i7 < this.columns; ++i7) {
                    this.V[i7][k] = 0.0;
                }
                this.V[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        block35: while (p > 0 && iter <= 25) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= this.tiny + this.eps * (Math.abs(this.single[k3]) + Math.abs(this.single[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.single[ks]) <= this.tiny + this.eps * t4)) continue;
                    this.single[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            ++iter;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = StrictMath.hypot(this.single[j4], f);
                        cs = this.single[j4] / t5;
                        sn = f / t5;
                        this.single[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (i8 = 0; i8 < this.columns; ++i8) {
                            t5 = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                            this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                            this.V[i8][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = StrictMath.hypot(this.single[j5], f);
                        cs = this.single[j5] / t5;
                        sn = f / t5;
                        this.single[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (i8 = 0; i8 < this.rows; ++i8) {
                            t5 = cs * this.U[i8][j5] + sn * this.U[i8][k3 - 1];
                            this.U[i8][k3 - 1] = -sn * this.U[i8][j5] + cs * this.U[i8][k3 - 1];
                            this.U[i8][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.single[p - 1]), Math.abs(this.single[p - 2])), Math.abs(e[p - 2])), Math.abs(this.single[k3])), Math.abs(e[k3]));
                    double sp = this.single[p - 1] / scale;
                    double spm1 = this.single[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.single[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i9;
                        double t6 = StrictMath.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.single[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.single[j6];
                        g = sn * this.single[j6 + 1];
                        this.single[j6 + 1] = cs * this.single[j6 + 1];
                        if (wantv) {
                            for (i9 = 0; i9 < this.columns; ++i9) {
                                t6 = cs * this.V[i9][j6] + sn * this.V[i9][j6 + 1];
                                this.V[i9][j6 + 1] = -sn * this.V[i9][j6] + cs * this.V[i9][j6 + 1];
                                this.V[i9][j6] = t6;
                            }
                        }
                        t6 = StrictMath.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.single[j6] = t6;
                        f = cs * e[j6] + sn * this.single[j6 + 1];
                        this.single[j6 + 1] = -sn * e[j6] + cs * this.single[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= this.rows - 1) continue;
                        for (i9 = 0; i9 < this.rows; ++i9) {
                            t6 = cs * this.U[i9][j6] + sn * this.U[i9][j6 + 1];
                            this.U[i9][j6 + 1] = -sn * this.U[i9][j6] + cs * this.U[i9][j6 + 1];
                            this.U[i9][j6] = t6;
                        }
                    }
                    e[p - 2] = f;
                    break;
                }
                case 4: {
                    if (this.single[k3] <= 0.0) {
                        double d = this.single[k3] = this.single[k3] < 0.0 ? -this.single[k3] : 0.0;
                        if (wantv) {
                            for (int i10 = 0; i10 <= pp; ++i10) {
                                this.V[i10][k3] = -this.V[i10][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.single[k3] >= this.single[k3 + 1])) {
                        int i11;
                        double t7 = this.single[k3];
                        this.single[k3] = this.single[k3 + 1];
                        this.single[k3 + 1] = t7;
                        if (wantv && k3 < this.columns - 1) {
                            for (i11 = 0; i11 < this.columns; ++i11) {
                                t7 = this.V[i11][k3 + 1];
                                this.V[i11][k3 + 1] = this.V[i11][k3];
                                this.V[i11][k3] = t7;
                            }
                        }
                        if (wantu && k3 < this.rows - 1) {
                            for (i11 = 0; i11 < this.rows; ++i11) {
                                t7 = this.U[i11][k3 + 1];
                                this.U[i11][k3 + 1] = this.U[i11][k3];
                                this.U[i11][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U);
    }

    public Matrix getV() {
        return new Matrix(this.V);
    }

    public double[] getSingularValues() {
        return this.single;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this.columns, this.columns);
        double[][] S = X.getDataRef();
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                S[i][j] = 0.0;
            }
            S[i][i] = this.single[i];
        }
        return X;
    }

    public double norm2() {
        return this.single[0];
    }

    public double cond() {
        return this.single[0] / this.single[Math.min(this.rows, this.columns) - 1];
    }

    public int rank() {
        double tol = (double)Math.max(this.rows, this.columns) * this.single[0] * this.eps;
        int r = 0;
        for (int i = 0; i < this.single.length; ++i) {
            if (!(this.single[i] > tol)) continue;
            ++r;
        }
        return r;
    }

    public Matrix inverse() throws InvalidMatrixException {
        double[][] inverse = new double[this.columns][this.rows];
        if (this.rank() > 0) {
            double tol = (double)Math.max(this.rows, this.columns) * this.single[0] * this.eps;
            double[] reciprocalS = new double[this.single.length];
            for (int x = 0; x < this.single.length; ++x) {
                reciprocalS[x] = Math.abs(this.single[x]) < tol ? 0.0 : 1.0 / this.single[x];
            }
            int min = Math.min(this.columns, this.U[0].length);
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.U.length; ++j) {
                    for (int k = 0; k < min; ++k) {
                        double[] dArray = inverse[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.V[i][k] * reciprocalS[k] * this.U[j][k];
                    }
                }
            }
        }
        return new Matrix(inverse);
    }

    protected static void print(double[][] a) {
        System.out.println("Start Matrix");
        for (int x = 0; x < a.length; ++x) {
            for (int y = 0; y < a[0].length; ++y) {
                System.out.print(a[x][y] + " ");
            }
            System.out.println("");
        }
        System.out.println("End Matrix");
    }

    protected static void print(double[] a) {
        System.out.println("Start vector");
        for (int x = 0; x < a.length; ++x) {
            System.out.print(a[x] + " ");
        }
        System.out.println("\nEnd vector");
    }
}

