/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.DifferentArrayLengthException;
import commonSense.math.linear.Matrix;

public class PointXD
extends Matrix {
    private static final long serialVersionUID = 1L;
    public final int X = 0;
    public final int Y = 1;
    public final int Z = 2;
    public final int W = 3;
    protected int dim = 0;

    public PointXD() {
    }

    public PointXD(int dim) {
        this.dim = dim;
        this.data = new double[1][dim];
    }

    public PointXD(double slope) {
        this(-1.0, slope);
    }

    public PointXD(double x, double y) {
        this(2);
        this.data[0][0] = x;
        this.data[0][1] = y;
    }

    public PointXD(double x, double y, double z) {
        this(3);
        this.data[0][0] = x;
        this.data[0][1] = y;
        this.data[0][2] = z;
    }

    public PointXD(double x, double y, double z, double w) {
        this(4);
        this.data[0][0] = x;
        this.data[0][1] = y;
        this.data[0][2] = z;
        this.data[0][3] = w;
    }

    public PointXD(double[] values) {
        this(values.length);
        System.arraycopy(values, 0, this.data[0], 0, this.dim);
    }

    @Override
    public PointXD scalarMultiply(double d) {
        PointXD mv = new PointXD(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            mv.data[0][i] = this.data[0][i] * d;
        }
        return mv;
    }

    @Override
    public PointXD scalarAdd(double d) {
        PointXD mv = new PointXD(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            mv.data[0][i] = this.data[0][i] + d;
        }
        return mv;
    }

    public PointXD add(PointXD toAdd) {
        if (toAdd.dim != this.dim) {
            throw new DifferentArrayLengthException("Dimension of toAdd (" + toAdd.dim + ") does not match  this object (" + this.dim + ")");
        }
        PointXD mv = new PointXD(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            mv.data[0][i] = this.data[0][i] + toAdd.data[0][i];
        }
        return mv;
    }

    public static double norm(double[] vector) {
        double norm = 0.0;
        for (int x = 0; x < vector.length; ++x) {
            norm += vector[x] * vector[x];
        }
        return StrictMath.sqrt(norm);
    }

    public static double[] toArray(double slope) {
        double[] v = new double[]{-1.0, slope};
        return v;
    }

    @Override
    public String toString() {
        String s = "MathVector: " + this.data[0][0];
        for (int i = 1; i < this.data[0].length; ++i) {
            s = s + ", " + this.data[0][i];
        }
        return s;
    }

    public double[] getCoordinates() {
        double[] out = new double[this.dim];
        System.arraycopy(this.data[0], 0, out, 0, this.dim);
        return out;
    }

    @Override
    public PointXD copy() {
        return new PointXD(this.getCoordinates());
    }

    public double[] getCoordinateRef() {
        return this.data[0];
    }

    public double getX() {
        return this.data[0][0];
    }

    public double getY() {
        return this.data[0][1];
    }

    public double getZ() {
        return this.data[0][2];
    }

    public double getW() {
        return this.data[0][3];
    }

    public double getCoordinate(int location) {
        return this.data[0][location];
    }
}

