/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.DifferentArrayLengthException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.PointXD;

public class LineXD
extends Matrix {
    private static final long serialVersionUID = 1L;
    protected int dim = 0;

    public LineXD(PointXD p1, PointXD p2) {
        if (p1.dim != p2.dim) {
            throw new DifferentArrayLengthException();
        }
        this.data = new double[2][p1.dim];
        for (int x = 0; x < p1.dim; ++x) {
            this.data[0][x] = p1.getCoordinate(x);
            this.data[1][x] = p2.getCoordinate(x);
        }
    }

    public LineXD(double x1, double y1, double x2, double y2) {
        this(new PointXD(x1, y1), new PointXD(x2, y2));
    }

    public PointXD projectPointToLine(PointXD point) {
        return this.projectPointToLine(point.getX(), point.getY());
    }

    public PointXD projectPointToLine(double x3, double y3) {
        double r = this.getFraction(x3, y3);
        return new PointXD(this.data[0][0] + r * (this.data[1][0] - this.data[0][0]), this.data[0][1] + r * (this.data[1][1] - this.data[0][1]));
    }

    public PointXD projectPointToSegment(PointXD point) {
        return this.projectPointToSegment(point.getX(), point.getY());
    }

    public PointXD projectPointToSegment(double x3, double y3) {
        double r = this.getFraction(x3, y3);
        if (r < 0.0) {
            return new PointXD(this.data[0][0], this.data[0][1]);
        }
        if (r > 1.0) {
            return new PointXD(this.data[1][0], this.data[1][1]);
        }
        return new PointXD(this.data[0][0] + r * (this.data[1][0] - this.data[0][0]), this.data[0][1] + r * (this.data[1][1] - this.data[0][1]));
    }

    public double getFraction(PointXD point) {
        return this.getFraction(point.getX(), point.getY());
    }

    public PointXD getPointOnSegment(double fraction) {
        if (fraction < 0.0) {
            return new PointXD(this.data[0][0], this.data[0][1]);
        }
        if (fraction > 1.0) {
            return new PointXD(this.data[1][0], this.data[1][1]);
        }
        return new PointXD(this.data[0][0] + fraction * (this.data[1][0] - this.data[0][0]), this.data[0][1] + fraction * (this.data[1][1] - this.data[0][1]));
    }

    public PointXD getPointOnLine(double fraction) {
        return new PointXD(this.data[0][0] + fraction * (this.data[1][0] - this.data[0][0]), this.data[0][1] + fraction * (this.data[1][1] - this.data[0][1]));
    }

    public double getFraction(double x3, double y3) {
        return ((this.data[0][0] - x3) * (this.data[0][0] - this.data[1][0]) + (this.data[0][1] - y3) * (this.data[0][1] - this.data[1][1])) / ((this.data[0][0] - this.data[1][0]) * (this.data[0][0] - this.data[1][0]) + (this.data[0][1] - this.data[1][1]) * (this.data[0][1] - this.data[1][1]));
    }

    public double getSlope() {
        return (this.data[1][1] - this.data[0][1]) / (this.data[1][0] - this.data[0][0]);
    }

    public double getIntercept() {
        return this.data[0][1] - this.getSlope() * this.data[0][0];
    }
}

