/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.curves;

import commonSense.DifferentArrayLengthException;
import commonSense.math.curves.AbstractBSpline;
import commonSense.math.linear.PointXD;

public class OpenBSpline
extends AbstractBSpline {
    protected OpenBSpline() {
    }

    public OpenBSpline(int degree) {
        this.p = degree;
    }

    public OpenBSpline(int degree, double[][] points) {
        this.p = degree;
        this.n = points.length - 1;
        for (int x = 0; x <= this.n; ++x) {
            this.controlPoints.add(x, new PointXD(points[x][0], points[x][1]));
        }
    }

    public OpenBSpline(int degree, double[] xPoints, double[] yPoints) {
        this.p = degree;
        if (xPoints.length != yPoints.length) {
            throw new DifferentArrayLengthException("Length differ: " + xPoints.length + " versus " + yPoints.length);
        }
        this.n = xPoints.length - 1;
        for (int x = 0; x <= this.n; ++x) {
            this.controlPoints.add(x, new PointXD(xPoints[x], yPoints[x]));
        }
    }

    public OpenBSpline(int degree, PointXD[] points) {
        this.p = degree;
        this.n = points.length - 1;
        for (int x = 0; x <= this.n; ++x) {
            this.controlPoints.add(x, points[x]);
        }
    }

    @Override
    protected void createKnotVector() {
        this.m = this.n + this.p + 1;
        int knotsN = this.m + 1;
        this.T = new double[knotsN];
        for (int x = 0; x < knotsN; ++x) {
            this.T[x] = (double)x * 1.0 / (double)this.m * 1.0;
        }
    }
}

