/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.curves;

import commonSense.math.curves.AbstractBSpline;
import commonSense.math.curves.AbstractSplineMath;
import commonSense.math.linear.Distances;
import commonSense.math.linear.PointXD;

public class BSplineMath
extends AbstractSplineMath {
    AbstractBSpline spline = null;
    double[] validRange = new double[]{0.0, 1.0};
    double[] knotVectorValues = null;

    public BSplineMath(AbstractBSpline spline) {
        this.spline = spline;
        if (spline.T == null) {
            spline.checkKnotVector();
        }
        this.n = spline.n * 10;
    }

    public double[] estimateTValues(int intervals) {
        double[] range = this.spline.getValidKnotInterval();
        double curveLength = this.curveLength(range[0], range[1]);
        double[] tValues = new double[intervals + 1];
        tValues[0] = this.knotVectorValues[0];
        tValues[intervals] = this.knotVectorValues[this.knotVectorValues.length - 1];
        for (int x = 1; x < intervals; ++x) {
            tValues[x] = this.estimateTValue(range[0], range[1], (double)x * 1.0 / (double)intervals, curveLength);
        }
        return tValues;
    }

    public double[] estimateTValuesClosedInterval(int intervals) {
        double[] range = this.spline.getValidKnotInterval();
        double curveLength = this.curveLength(range[0], range[1]);
        double[] tValues = new double[intervals + 1];
        tValues[0] = this.knotVectorValues[0];
        tValues[intervals] = this.knotVectorValues[this.knotVectorValues.length - 1];
        for (int x = 1; x < intervals; ++x) {
            tValues[x] = this.estimateTValue(range[0], range[1], (double)x * 1.0 / (double)intervals, curveLength);
        }
        return tValues;
    }

    public double[] estimateTValues(double tStart, double tEnd, int intervals) {
        double curveLength = this.curveLength(tStart, tEnd);
        double[] tValues = new double[intervals + 1];
        tValues[0] = this.knotVectorValues[0];
        tValues[intervals + 1] = this.knotVectorValues[intervals + 1];
        for (int x = 1; x < intervals; ++x) {
            tValues[x] = this.estimateTValue(tStart, tEnd, x / intervals, curveLength);
        }
        return tValues;
    }

    public double[] estimateTValues(double tStart, double tEnd, double[] fractionValues) {
        double[] tValues = new double[fractionValues.length];
        for (int x = 0; x < fractionValues.length; ++x) {
            tValues[x] = this.estimateTValue(tStart, tEnd, fractionValues[x], this.curveLength(tStart, tEnd));
        }
        return tValues;
    }

    public double estimateTValue(double fraction) {
        double[] range = this.spline.getValidKnotInterval();
        return this.estimateTValue(range[0], range[1], fraction, this.curveLength(range[0], range[1]));
    }

    public double estimateTValue(double tStart, double tEnd, double fraction) {
        return this.estimateTValue(tStart, tEnd, fraction, this.curveLength(tStart, tEnd));
    }

    private double estimateTValue(double tStart, double tEnd, double fraction, double curveLength) {
        double fractionLength;
        double tempLength = fractionLength = curveLength * fraction;
        int interval = 0;
        for (int x = 0; x < this.segmentLengths.length; ++x) {
            if (tempLength < this.segmentLengths[x]) {
                interval = x;
                break;
            }
            tempLength -= this.segmentLengths[x];
        }
        double start = this.knotVectorValues[interval];
        double end = this.knotVectorValues[interval + 1];
        double mid = (start + end) / 2.0;
        PointXD startPoint = this.points[interval];
        PointXD midPoint = this.spline.getPoint(mid);
        PointXD endPoint = this.points[interval + 1];
        double lengthFragment = 0.0;
        int count = 0;
        while (Math.abs(tempLength - lengthFragment) > this.tolerance) {
            lengthFragment = this.estimateCurveSegment(0, startPoint, start, midPoint, mid);
            if (tempLength < lengthFragment) {
                end = mid;
                endPoint = midPoint;
            } else {
                tempLength -= lengthFragment;
                start = mid;
                startPoint = midPoint;
            }
            mid = (start + end) / 2.0;
            midPoint = this.spline.getPoint(mid);
            if (++count <= 100) continue;
            break;
        }
        return mid;
    }

    @Override
    public double curveLength(double tStart, double tEnd) {
        this.validRange = this.checkValidKnotRange(tStart, tEnd);
        this.points = new PointXD[this.n + 1];
        this.knotVectorValues = new double[this.n + 1];
        this.segmentLengths = new double[this.n];
        double range = this.validRange[1] - this.validRange[0];
        double step = range / ((double)this.n * 1.0);
        this.knotVectorValues[0] = this.validRange[0];
        this.points[0] = this.spline.getPoint(this.knotVectorValues[0]);
        double length = 0.0;
        for (int x = 0; x < this.n; ++x) {
            this.knotVectorValues[x + 1] = this.validRange[0] + ((double)x + 1.0) * step;
            this.points[x + 1] = this.spline.getPoint(this.knotVectorValues[x + 1]);
            this.segmentLengths[x] = this.estimateCurveSegment(0, this.points[x], this.knotVectorValues[x], this.points[x + 1], this.knotVectorValues[x + 1]);
            length += this.segmentLengths[x];
        }
        return length;
    }

    public double closedCurveLength() {
        double length = this.curveLength(0.0, 1.0);
        return length;
    }

    protected double estimateCurveSegment(int depth, PointXD start, double tStart, PointXD end, double tEnd) {
        double d2;
        double d1;
        double tMid = (tStart + tEnd) / 2.0;
        PointXD mid = this.spline.getPoint(tMid);
        double d0 = Distances.pointPoint(start, end);
        if (Math.abs(d0 - ((d1 = Distances.pointPoint(start, mid)) + (d2 = Distances.pointPoint(mid, end)))) > this.tolerance) {
            d1 = this.estimateCurveSegment(++depth, start, tStart, mid, tMid);
            d2 = this.estimateCurveSegment(depth, mid, tMid, end, tEnd);
        }
        return d1 + d2;
    }

    @Override
    public double findParameter(double x, double y) {
        if (this.points == null) {
            this.points = this.spline.getCurve(this.n);
        }
        double d = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double t0 = 0.0;
        double tmin = 0.0;
        double dmin = Double.MAX_VALUE;
        double[] range = this.spline.getValidKnotInterval();
        double increment = (range[1] - range[0]) / (double)this.n;
        for (int currentStep = 0; currentStep <= this.n; ++currentStep) {
            dx = this.points[currentStep].getX() - x;
            d = StrictMath.sqrt(dx * dx + (dy = this.points[currentStep].getY() - y) * dy);
            if (!(d < dmin)) continue;
            dmin = d;
            tmin = range[0] + increment * (double)currentStep;
        }
        double t = 0.0;
        double dif = Double.MAX_VALUE;
        PointXD temp = null;
        int count = 0;
        while (++count <= 100) {
            increment /= 2.0;
            t0 = tmin;
            for (int step = -2; step <= 2; ++step) {
                t = t0 + (double)step * increment;
                temp = this.spline.getPoint(t);
                if (temp == null || !((d = StrictMath.sqrt((dx = temp.getX() - x) * dx + (dy = temp.getY() - y) * dy)) < dmin)) continue;
                dif = Math.abs(d - dmin);
                dmin = d;
                tmin = t;
            }
            if (dif > this.tolerance) continue;
        }
        return tmin;
    }

    @Override
    public PointXD findClosestPoint(double x, double y) {
        return this.spline.getPoint(this.findParameter(x, y));
    }

    protected double[] checkValidKnotRange(double[] range) {
        double[] validRangeCopy = new double[]{0.0, 1.0};
        if (range[1] < range[0]) {
            validRangeCopy[0] = range[1];
            validRangeCopy[1] = range[0];
        } else {
            validRangeCopy[0] = range[0];
            validRangeCopy[1] = range[1];
        }
        double[] tRange = this.spline.getValidKnotInterval();
        if (validRangeCopy[0] < tRange[0]) {
            validRangeCopy[0] = tRange[0];
        }
        if (validRangeCopy[1] > tRange[1]) {
            validRangeCopy[1] = tRange[1];
        }
        return validRangeCopy;
    }

    protected double[] checkValidKnotRange(double begin, double end) {
        double[] range = new double[]{begin, end};
        return this.checkValidKnotRange(range);
    }

    public double[][] extractPoints(double[] parameterValues) {
        double[][] values = new double[parameterValues.length][2];
        PointXD temp = null;
        for (int x = 0; x < parameterValues.length; ++x) {
            temp = this.spline.getPoint(parameterValues[x]);
            values[x][0] = temp.getX();
            values[x][1] = temp.getY();
        }
        return values;
    }
}

