/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.curves;

import commonSense.math.linear.PointXD;
import java.util.ArrayList;

public abstract class AbstractSpline {
    protected ArrayList<PointXD> controlPoints = new ArrayList();
    protected int n = -1;

    public int getNoControlPoints() {
        return this.n + 1;
    }

    protected PointXD getControlPoint(int i) {
        return this.controlPoints.get(i);
    }

    protected PointXD getBeginControlPoint() {
        return this.getControlPoint(0);
    }

    protected PointXD getEndControlPoint() {
        return this.getControlPoint(this.n);
    }

    public ArrayList<PointXD> getControlPoints() {
        return this.controlPoints;
    }

    public abstract void setControlPoint(int var1, PointXD var2);

    public void insertControlPoint(int location, PointXD c) {
        this.setControlPoint(location, c);
    }

    public abstract void removeControlPoint(int var1);

    public abstract PointXD getPoint(double var1);

    public abstract PointXD[] getCurve(int var1);

    public double[][] getCurveCoordinates(int intervals) {
        return this.extractValues(this.getCurve(intervals));
    }

    protected double[][] extractValues(PointXD[] points) {
        int steps = points.length;
        double[][] data = new double[steps][2];
        for (int currentStep = 0; currentStep < steps; ++currentStep) {
            data[currentStep][0] = points[currentStep].getX();
            data[currentStep][1] = points[currentStep].getY();
        }
        return data;
    }
}

