/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.curves;

import commonSense.math.curves.AbstractSpline;
import commonSense.math.linear.PointXD;

public abstract class AbstractBSpline
extends AbstractSpline {
    protected double[] T = null;
    protected int p = -1;
    protected int m = 0;
    protected double[] lengths = null;

    protected abstract void createKnotVector();

    protected void checkKnotVector() {
        if (this.T == null) {
            this.createKnotVector();
        }
    }

    public void setDegree(int degree) {
        this.p = degree;
    }

    @Override
    public void setControlPoint(int location, PointXD c) {
        this.controlPoints.add(location, c);
        this.T = null;
        ++this.n;
    }

    @Override
    public void removeControlPoint(int location) {
        this.controlPoints.remove(location);
        this.T = null;
        --this.n;
    }

    @Override
    public PointXD[] getCurve(int intervals) {
        this.checkKnotVector();
        return this.getCurve(intervals, this.T[this.p], this.T[this.m - this.p]);
    }

    public PointXD[] getCurve(int intervals, double start, double end) {
        this.checkKnotVector();
        if (this.n > 0) {
            PointXD[] points = new PointXD[intervals + 1];
            double t = 0.0;
            double increment = (end - start) / (double)intervals;
            for (int currentStep = 0; currentStep <= intervals; ++currentStep) {
                t = start + increment * (double)currentStep;
                points[currentStep] = this.getPoint(t);
            }
            return points;
        }
        return null;
    }

    public double[] getValidKnotInterval() {
        double[] z = new double[]{this.T[this.p], this.T[this.m - this.p]};
        return z;
    }

    @Override
    public PointXD getPoint(double t) {
        this.checkKnotVector();
        if (t < this.T[this.p] || t > this.T[this.m - this.p]) {
            return null;
        }
        PointXD result = new PointXD(0.0, 0.0);
        double weight = 0.0;
        for (int i = 0; i <= this.n; ++i) {
            weight = this.coxDeBoor(i, this.p, t);
            PointXD temp = this.getControlPoint(i).scalarMultiply(weight);
            result = result.add(temp);
        }
        return result;
    }

    public double coxDeBoor(int i, int p, double t) {
        double denom2;
        this.checkKnotVector();
        double high = this.T[i + p + 1];
        double low = this.T[i];
        if (high == low) {
            return 0.0;
        }
        if (p == 0) {
            if (t == 1.0 && i == this.n) {
                return t >= this.T[i] && t <= this.T[i + 1] ? 1.0 : 0.0;
            }
            return t >= this.T[i] && t < this.T[i + 1] ? 1.0 : 0.0;
        }
        if (t < low || t > high) {
            return 0.0;
        }
        double weight = 0.0;
        double denom1 = this.T[i + p] - low;
        if (denom1 != 0.0) {
            weight += (t - low) / denom1 * this.coxDeBoor(i, p - 1, t);
        }
        if ((denom2 = high - this.T[i + 1]) > 0.0) {
            weight += (high - t) / denom2 * this.coxDeBoor(i + 1, p - 1, t);
        }
        return weight;
    }
}

