/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.analysis;

import commonSense.math.analysis.DifferentiableUnivariateRealFunction;
import commonSense.math.analysis.UnivariateRealFunction;
import java.io.Serializable;

public class PolynomialFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    static final long serialVersionUID = 3322454535052136809L;
    private double[] coefficients;

    public PolynomialFunction(double[] c) {
        if (c.length < 1) {
            throw new IllegalArgumentException("Polynomial coefficient array must have postive length.");
        }
        this.coefficients = new double[c.length];
        System.arraycopy(c, 0, this.coefficients, 0, c.length);
    }

    @Override
    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n = coefficients.length;
        if (n < 1) {
            throw new IllegalArgumentException("Coefficient array must have positive length for evaluation");
        }
        double result = coefficients[n - 1];
        for (int j = n - 2; j >= 0; --j) {
            result = argument * result + coefficients[j];
        }
        return result;
    }

    protected static double[] differentiate(double[] coefficients) {
        int n = coefficients.length;
        if (n < 1) {
            throw new IllegalArgumentException("Coefficient array must have positive length for differentiation");
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        for (int i = n - 1; i > 0; --i) {
            result[i - 1] = (double)i * coefficients[i];
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    @Override
    public UnivariateRealFunction derivative() {
        return this.polynomialDerivative();
    }
}

