/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.analysis;

import commonSense.math.ConvergenceException;
import commonSense.math.FunctionEvaluationException;
import commonSense.math.analysis.UnivariateRealFunction;
import commonSense.math.analysis.UnivariateRealSolverImpl;
import commonSense.math.analysis.UnivariateRealSolverUtils;

public class BisectionSolver
extends UnivariateRealSolverImpl {
    static final long serialVersionUID = 7137520585963699578L;

    public BisectionSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    @Override
    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max);
    }

    @Override
    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(min, max);
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            double m = UnivariateRealSolverUtils.midpoint(min, max);
            double fmin = this.f.value(min);
            double fm = this.f.value(m);
            if (fm * fmin > 0.0) {
                min = m;
            } else {
                max = m;
            }
            if (!(Math.abs(max - min) <= this.absoluteAccuracy)) continue;
            m = UnivariateRealSolverUtils.midpoint(min, max);
            this.setResult(m, i);
            return m;
        }
        throw new ConvergenceException("Maximum number of iterations exceeded: " + this.maximalIterationCount);
    }
}

