/*
 * Decompiled with CFR 0.152.
 */
package commonSense.graphs.components;

import java.awt.Graphics;

public abstract class Axis {
    private double minValue;
    private double maxValue;
    private int length = 0;
    private int width = 0;
    private int noMajorTickMarks = 10;
    private int noMinorTickMarks = 4;
    private boolean showMinorTickMarks = false;
    private boolean showMajorTickMarks = false;
    private boolean showLabels = true;
    private String label = "";
    private int orientation;

    public Axis(double maxValue, int length) {
        this(0.0, maxValue, length, 25);
    }

    public Axis(double minValue, double maxValue, int length) {
        this(minValue, maxValue, length, 25);
    }

    public Axis(double minValue, double maxValue, int length, int width) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.length = length;
        this.width = width;
    }

    public void drawAxis(Graphics g, int x, int y) {
        g.drawLine(this.width, 0, this.width, this.length);
    }

    public boolean showLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getNoMajorTickMarks() {
        return this.noMajorTickMarks;
    }

    public int getNoMinorTickMarks() {
        return this.noMinorTickMarks;
    }

    public boolean showMinorTickMarks() {
        return this.showMinorTickMarks;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setNoMajorTickMarks(int noMajorTickMarks) {
        this.noMajorTickMarks = noMajorTickMarks;
    }

    public void setNoMinorTickMarks(int noMinorTickMarks) {
        this.noMinorTickMarks = noMinorTickMarks;
    }

    public void setShowMinorTickMarks(boolean showMinorTickMarks) {
        this.showMinorTickMarks = showMinorTickMarks;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isShowMajorTickMarks() {
        return this.showMajorTickMarks;
    }

    public void setShowMajorTickMarks(boolean showMajorTickMarks) {
        this.showMajorTickMarks = showMajorTickMarks;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public double CalcStepSize(double range, double targetSteps) {
        double tempStep = range / targetSteps;
        double mag = Math.floor(Math.log10(tempStep));
        double magPow = Math.pow(10.0, mag);
        double magMsd = tempStep / magPow + 0.5;
        if (magMsd > 5.0) {
            magMsd = 10.0;
        } else if (magMsd > 2.0) {
            magMsd = 5.0;
        } else if (magMsd > 1.0) {
            magMsd = 2.0;
        }
        return magMsd * magPow;
    }
}

