/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.common.LZWCompressor;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class TIFFLZWCompressor
extends TIFFCompressor {
    int predictor;

    public TIFFLZWCompressor(int predictorValue) {
        super("LZW", 5, true);
        this.predictor = predictorValue;
    }

    public void setStream(ImageOutputStream stream) {
        super.setStream(stream);
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        boolean usePredictor;
        LZWCompressor lzwCompressor = new LZWCompressor(this.stream, 8, true);
        int samplesPerPixel = bitsPerSample.length;
        int bitsPerPixel = 0;
        int i = 0;
        while (i < samplesPerPixel) {
            bitsPerPixel += bitsPerSample[i];
            ++i;
        }
        int bytesPerRow = (bitsPerPixel * width + 7) / 8;
        long initialStreamPosition = this.stream.getStreamPosition();
        boolean bl = usePredictor = this.predictor == 2;
        if (bytesPerRow == scanlineStride && !usePredictor) {
            lzwCompressor.compress(b, off, bytesPerRow * height);
        } else {
            byte[] rowBuf = usePredictor ? new byte[bytesPerRow] : null;
            int i2 = 0;
            while (i2 < height) {
                if (usePredictor) {
                    System.arraycopy(b, off, rowBuf, 0, bytesPerRow);
                    int j = bytesPerRow - 1;
                    while (j >= samplesPerPixel) {
                        int n = j;
                        rowBuf[n] = (byte)(rowBuf[n] - rowBuf[j - samplesPerPixel]);
                        --j;
                    }
                    lzwCompressor.compress(rowBuf, 0, bytesPerRow);
                } else {
                    lzwCompressor.compress(b, off, bytesPerRow);
                }
                off += scanlineStride;
                ++i2;
            }
        }
        lzwCompressor.flush();
        int bytesWritten = (int)(this.stream.getStreamPosition() - initialStreamPosition);
        return bytesWritten;
    }
}

