/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.ImageWriteParam;

public class TIFFDeflater
extends TIFFCompressor {
    Deflater deflater;
    int predictor;

    public TIFFDeflater(String compressionType, int compressionTagValue, ImageWriteParam param, int predictorValue) {
        super(compressionType, compressionTagValue, true);
        int deflateLevel;
        this.predictor = predictorValue;
        if (param != null && param.getCompressionMode() == 2) {
            float quality = param.getCompressionQuality();
            deflateLevel = (int)(1.0f + 8.0f * quality);
        } else {
            deflateLevel = -1;
        }
        this.deflater = new Deflater(deflateLevel);
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int inputSize = height * scanlineStride;
        int blocks = (inputSize + Short.MAX_VALUE) / 32768;
        byte[] compData = new byte[inputSize + 5 * blocks + 6];
        int numCompressedBytes = 0;
        if (this.predictor == 2) {
            int samplesPerPixel = bitsPerSample.length;
            int bitsPerPixel = 0;
            int i = 0;
            while (i < samplesPerPixel) {
                bitsPerPixel += bitsPerSample[i];
                ++i;
            }
            int bytesPerRow = (bitsPerPixel * width + 7) / 8;
            byte[] rowBuf = new byte[bytesPerRow];
            int maxRow = height - 1;
            int i2 = 0;
            while (i2 < height) {
                System.arraycopy(b, off, rowBuf, 0, bytesPerRow);
                int j = bytesPerRow - 1;
                while (j >= samplesPerPixel) {
                    int n = j;
                    rowBuf[n] = (byte)(rowBuf[n] - rowBuf[j - samplesPerPixel]);
                    --j;
                }
                this.deflater.setInput(rowBuf);
                if (i2 == maxRow) {
                    this.deflater.finish();
                }
                int numBytes = 0;
                while ((numBytes = this.deflater.deflate(compData, numCompressedBytes, compData.length - numCompressedBytes)) != 0) {
                    numCompressedBytes += numBytes;
                }
                off += scanlineStride;
                ++i2;
            }
        } else {
            this.deflater.setInput(b, off, height * scanlineStride);
            this.deflater.finish();
            numCompressedBytes = this.deflater.deflate(compData);
        }
        this.deflater.reset();
        this.stream.write(compData, 0, numCompressedBytes);
        return numCompressedBytes;
    }
}

