/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CLibPNGImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader";
    private static final String[] writerSpiNames;

    public CLibPNGImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            Object coreReaderSPI;
            Class<?> coreReaderSPIClass = null;
            try {
                coreReaderSPIClass = Class.forName("com.sun.imageio.plugins.png.PNGImageReaderSpi");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (coreReaderSPIClass != null && (coreReaderSPI = registry.getServiceProviderByClass(coreReaderSPIClass)) != null) {
                registry.setOrdering(category, this, coreReaderSPI);
            }
        }
    }

    public String getDescription(Locale locale) {
        return "codecLib PNG Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b = new byte[8];
        stream.mark();
        stream.readFully(b);
        stream.reset();
        return b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new CLibPNGImageReader(this);
    }

    static {
        readerClassName = readerClassName;
        writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriterSpi"};
    }
}

