/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriteParam;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Encoder;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibJPEGImageWriter
extends CLibImageWriter {
    private Encoder encoder;

    CLibJPEGImageWriter(ImageWriterSpi originatingProvider) throws IOException {
        super(originatingProvider);
        try {
            this.encoder = new Encoder();
            this.encoder.setExtend(0);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibJPEGImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int imgFormat;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter stream = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        stream = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = image.getRenderedImage();
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        int bitDepth = renderedImage.getColorModel().getComponentSize(0);
        if (!(param != null && param.isCompressionLossless() || bitDepth <= 12)) {
            throw new IIOException("JPEG baseline encoding is limited to 12 bits: " + this);
        }
        if (param != null && param.getCompressionMode() == 2) {
            if (param.isCompressionLossless()) {
                try {
                    if (bitDepth >= 2 && bitDepth <= 16 && bitDepth % 8 != 0) {
                        this.encoder.setDepth(bitDepth);
                    }
                    if (param.getCompressionType().equalsIgnoreCase("JPEG-LOSSLESS")) {
                        this.encoder.setMode(1);
                    }
                    this.encoder.setMode(2);
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
            } else {
                try {
                    this.encoder.setMode(0);
                    this.encoder.setQuality((int)(param.getCompressionQuality() * 100.0f));
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
            }
        } else {
            try {
                this.encoder.setMode(0);
                this.encoder.setQuality(75);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
        }
        mediaLibImage mlibImage = this.getMediaLibImage(renderedImage, param, false);
        switch (mlibImage.getChannels()) {
            case 1: {
                imgFormat = 2;
                break;
            }
            case 3: {
                imgFormat = 3;
                break;
            }
            default: {
                imgFormat = 0;
            }
        }
        mlibImage.setFormat(imgFormat);
        try {
            this.encoder.encode((OutputStream)stream, mlibImage);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }
}

