/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class CLibImageWriter
extends ImageWriter {
    private static final Object getDataBufferData(DataBuffer db) {
        Object[] data;
        int dType = db.getDataType();
        switch (dType) {
            case 0: {
                data = ((DataBufferByte)db).getData();
                break;
            }
            case 1: {
                data = ((DataBufferUShort)db).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dType);
            }
        }
        return data;
    }

    private static final int getMediaLibDataType(int dataType) {
        int mlibType;
        switch (dataType) {
            case 0: {
                mlibType = 1;
                break;
            }
            case 1: {
                mlibType = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dataType);
            }
        }
        return mlibType;
    }

    private static void reformat(Raster source, int[] sourceBands, int subsampleX, int subsampleY, WritableRaster dst) {
        if (source == null) {
            throw new IllegalArgumentException("source == null!");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst == null!");
        }
        Rectangle sourceBounds = source.getBounds();
        if (sourceBounds.isEmpty()) {
            throw new IllegalArgumentException("source.getBounds().isEmpty()!");
        }
        boolean isSubBanding = false;
        int numSourceBands = source.getSampleModel().getNumBands();
        if (sourceBands != null) {
            if (sourceBands.length > numSourceBands) {
                throw new IllegalArgumentException("sourceBands.length > numSourceBands!");
            }
            boolean isRamp = sourceBands.length == numSourceBands;
            int i = 0;
            while (i < sourceBands.length) {
                if (sourceBands[i] < 0 || sourceBands[i] >= numSourceBands) {
                    throw new IllegalArgumentException("sourceBands[i] < 0 || sourceBands[i] >= numSourceBands!");
                }
                if (sourceBands[i] != i) {
                    isRamp = false;
                }
                ++i;
            }
            isSubBanding = !isRamp;
        }
        int sourceWidth = sourceBounds.width;
        int[] pixels = new int[sourceWidth * numSourceBands];
        int sourceX = sourceBounds.x;
        int sourceY = sourceBounds.y;
        int numBands = sourceBands != null ? sourceBands.length : numSourceBands;
        int dstWidth = dst.getWidth();
        int dstYMax = dst.getHeight() - 1;
        int copyFromIncrement = numSourceBands * subsampleX;
        int dstY = 0;
        while (dstY <= dstYMax) {
            int i;
            int copyTo;
            int copyFrom;
            source.getPixels(sourceX, sourceY, sourceWidth, 1, pixels);
            if (isSubBanding) {
                copyFrom = 0;
                copyTo = 0;
                i = 0;
                while (i < dstWidth) {
                    int j = 0;
                    while (j < numBands) {
                        pixels[copyTo++] = pixels[copyFrom + sourceBands[j]];
                        ++j;
                    }
                    copyFrom += copyFromIncrement;
                    ++i;
                }
            } else {
                copyFrom = copyFromIncrement;
                copyTo = numSourceBands;
                i = 1;
                while (i < dstWidth) {
                    int k = copyFrom;
                    int j = 0;
                    while (j < numSourceBands) {
                        pixels[copyTo++] = pixels[k++];
                        ++j;
                    }
                    copyFrom += copyFromIncrement;
                    ++i;
                }
            }
            dst.setPixels(0, dstY, dstWidth, 1, pixels);
            sourceY += subsampleY;
            ++dstY;
        }
    }

    protected CLibImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    private static final Rectangle getSourceRegion(ImageWriteParam param, int sourceMinX, int sourceMinY, int srcWidth, int srcHeight) {
        Rectangle sourceRegion = new Rectangle(sourceMinX, sourceMinY, srcWidth, srcHeight);
        if (param != null) {
            Rectangle region = param.getSourceRegion();
            if (region != null) {
                sourceRegion = sourceRegion.intersection(region);
            }
            int subsampleXOffset = param.getSubsamplingXOffset();
            int subsampleYOffset = param.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        return sourceRegion;
    }

    protected mediaLibImage getMediaLibImage(RenderedImage image, ImageWriteParam param, boolean allowBilevel) {
        int numBands;
        int[] sourceBands;
        Rectangle sourceRegion = CLibImageWriter.getSourceRegion(param, image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        if (sourceRegion.isEmpty()) {
            throw new IllegalArgumentException("sourceRegion.isEmpty()");
        }
        boolean reformatData = false;
        boolean isBilevel = false;
        SampleModel sampleModel = image.getSampleModel();
        int numSourceBands = sampleModel.getNumBands();
        int[] nArray = sourceBands = param != null ? param.getSourceBands() : null;
        if (sourceBands != null) {
            numBands = sourceBands.length;
            if (numBands != numSourceBands) {
                reformatData = true;
            } else {
                int i = 0;
                while (i < numSourceBands) {
                    if (sourceBands[i] != i) {
                        reformatData = true;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            numBands = numSourceBands;
        }
        if (!(reformatData || param == null || param.getSourceXSubsampling() == 1 && param.getSourceXSubsampling() == 1)) {
            reformatData = true;
        }
        if (!reformatData) {
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
                if (csm.getPixelStride() != numSourceBands) {
                    reformatData = true;
                } else {
                    int[] bandOffsets = csm.getBandOffsets();
                    int i = 0;
                    while (i < numSourceBands) {
                        if (bandOffsets[i] != i) {
                            reformatData = true;
                            break;
                        }
                        ++i;
                    }
                }
            } else if (allowBilevel && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1 && sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getDataType() == 0) {
                MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
                if (mppsm.getPixelBitStride() == 1) {
                    isBilevel = true;
                } else {
                    reformatData = true;
                }
            } else {
                reformatData = true;
            }
        }
        Raster raster = null;
        if (reformatData) {
            SampleModel newSampleModel;
            int height;
            int width;
            int dataType;
            int[] sampleSize = sampleModel.getSampleSize();
            int bitDepthMax = sampleSize[0];
            int i = 1;
            while (i < numSourceBands) {
                bitDepthMax = Math.max(bitDepthMax, sampleSize[i]);
                ++i;
            }
            if (bitDepthMax <= 8) {
                dataType = 0;
            } else if (bitDepthMax <= 16) {
                dataType = 1;
            } else {
                throw new UnsupportedOperationException(I18N.getString("CLibImageWriter0") + " " + bitDepthMax);
            }
            if (param != null) {
                int subsampleX = param.getSourceXSubsampling();
                int subsampleY = param.getSourceYSubsampling();
                width = (sourceRegion.width + subsampleX - 1) / subsampleX;
                height = (sourceRegion.height + subsampleY - 1) / subsampleY;
            } else {
                width = sourceRegion.width;
                height = sourceRegion.height;
            }
            int[] newBandOffsets = new int[numBands];
            int i2 = 0;
            while (i2 < numBands) {
                newBandOffsets[i2] = i2;
                ++i2;
            }
            if (allowBilevel && sampleModel.getNumBands() == 1 && bitDepthMax == 1) {
                newSampleModel = new MultiPixelPackedSampleModel(dataType, width, height, 1);
                isBilevel = true;
            } else {
                newSampleModel = new PixelInterleavedSampleModel(dataType, width, height, newBandOffsets.length, width * numSourceBands, newBandOffsets);
            }
            WritableRaster newRaster = Raster.createWritableRaster(newSampleModel, null);
            if (param != null && (param.getSourceXSubsampling() != 1 || param.getSourceXSubsampling() != 1)) {
                CLibImageWriter.reformat(image.getData(sourceRegion), sourceBands, param.getSourceXSubsampling(), param.getSourceYSubsampling(), newRaster);
            } else if (sourceBands == null && image.getSampleModel().getClass().isInstance(newSampleModel) && newSampleModel.getTransferType() == image.getSampleModel().getTransferType()) {
                WritableRaster translatedChild = newRaster.createWritableTranslatedChild(sourceRegion.x, sourceRegion.y);
                image.copyData(translatedChild);
            } else {
                WritableRaster translatedChild = newRaster.createWritableTranslatedChild(sourceRegion.x, sourceRegion.y);
                Raster sourceRaster = image.getData(sourceRegion);
                if (sourceBands != null) {
                    sourceRaster = sourceRaster.createChild(sourceRegion.x, sourceRegion.y, sourceRegion.width, sourceRegion.height, sourceRegion.x, sourceRegion.y, sourceBands);
                }
                translatedChild.setRect(sourceRaster);
            }
            raster = newRaster;
            sampleModel = newRaster.getSampleModel();
        } else {
            raster = image.getData(sourceRegion).createTranslatedChild(0, 0);
            sampleModel = raster.getSampleModel();
        }
        mediaLibImage mlibImage = null;
        if (isBilevel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            int stride = mppsm.getScanlineStride();
            int offset = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * stride - raster.getSampleModelTranslateX() / 8 + mppsm.getOffset(0, 0);
            Object bitData = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            mlibImage = new mediaLibImage(0, 1, raster.getWidth(), raster.getHeight(), stride, offset, (byte)mppsm.getBitOffset(0), bitData);
        } else {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            int mlibDataType = CLibImageWriter.getMediaLibDataType(sampleModel.getDataType());
            Object data = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            int stride = csm.getScanlineStride();
            int offset = csm.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
            mlibImage = new mediaLibImage(mlibDataType, numSourceBands, raster.getWidth(), raster.getHeight(), stride, offset, data);
        }
        return mlibImage;
    }
}

