/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import commonSense.math.linear.LUDecomposition;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.PointXD;
import commonSense.math.linear.geometrics.Geometrics;
import java.awt.Point;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.splining.SpliningException;
import kim.bin.bio.wings.util.Side;

public class RegisterSplineModel
implements Side,
IndividualStatus {
    private static final int maxNoJoints = 50;
    private static final int NFEATURES = 12;
    private static final double FEAT_ACCP_ZONE = 0.2;
    private static final int TIP_TO_REF_DIST = 180;
    private static final int FEAT_ZONE_PIX = 10;
    private Point[] joints = null;
    private double[] affine = new double[6];
    private SplineGroup splines;
    private SplineGroup registeredSplines;
    private PointXD[] userPoints;
    private Individual ind;
    private PointXD[] featurePoints = null;
    private PointXD[] bestFeaturePoints = null;
    private PointXD[] repositionedFeature1 = null;
    private PointXD[] repositionedFeature2 = null;
    private double[] XS = null;
    private int noFeaturePoints = 7;
    private int noFeaturePointsSmall = this.noFeaturePoints - 2;

    public RegisterSplineModel(int[][] data, SplineGroup splineGroup, PointXD[] userPoints, Individual individual) {
        this.splines = splineGroup;
        this.userPoints = userPoints;
        this.ind = individual;
        this.findJoints(data);
        try {
            this.registration();
        }
        catch (SpliningException ex) {
            individual.setProcessingStatus(7);
        }
        this.mapmodel();
    }

    private void findJoints(int[][] data) {
        Point[] tempJoints = new Point[50];
        int rowsMinusOne = data.length - 1;
        int columnsMinusOne = data[0].length - 1;
        int[] di = new int[]{0, -1, -1, -1, 0, 1, 1, 1, 0};
        int[] dj = new int[]{1, 1, 0, -1, -1, -1, 0, 1, 1};
        int jointCount = 0;
        for (int i = 1; i < rowsMinusOne; ++i) {
            for (int j = 1; j < columnsMinusOne; ++j) {
                if (data[i][j] != 255) continue;
                int nb = 0;
                for (int k = 0; k < 8; ++k) {
                    int k1 = (k + 1) % 8;
                    if (data[i + di[k]][j + dj[k]] != 0 || data[i + di[k1]][j + dj[k1]] != 255) continue;
                    ++nb;
                }
                if (nb <= 2) continue;
                tempJoints[jointCount++] = new Point(i, j);
                if (jointCount < 50) continue;
                this.joints = new Point[jointCount];
                System.arraycopy(tempJoints, 0, this.joints, 0, jointCount);
                return;
            }
        }
        this.joints = new Point[jointCount];
        System.arraycopy(tempJoints, 0, this.joints, 0, jointCount);
    }

    public Point[] getJoints() {
        return this.joints;
    }

    public PointXD[] getFeaturePoints() {
        return this.featurePoints;
    }

    public PointXD[] getBestFeaturePoints() {
        return this.bestFeaturePoints;
    }

    public PointXD[] getF1() {
        return this.repositionedFeature1;
    }

    public PointXD[] getF2() {
        return this.repositionedFeature2;
    }

    private void registration() throws SpliningException {
        int j;
        int noJoints = this.joints.length;
        int[] match = new int[this.noFeaturePoints];
        int[] tmp_match = new int[this.noFeaturePoints];
        this.featurePoints = new PointXD[this.noFeaturePoints];
        this.repositionedFeature1 = new PointXD[this.noFeaturePointsSmall];
        this.repositionedFeature2 = new PointXD[this.noFeaturePointsSmall];
        this.bestFeaturePoints = new PointXD[this.noFeaturePoints];
        double minerr = 1000.0;
        SplineGroup newSplines = this.splines.splineGroupCopy();
        double[] tempPoint = null;
        for (int i = 1; i <= 4; ++i) {
            tempPoint = newSplines.getSpline(i).getBeginPoint();
            this.featurePoints[i - 1] = new PointXD(tempPoint[0], tempPoint[1]);
            this.repositionedFeature1[i - 1] = new PointXD(0.0, 0.0);
            this.repositionedFeature2[i - 1] = new PointXD(0.0, 0.0);
        }
        tempPoint = newSplines.getSpline(6).getBeginPoint();
        this.featurePoints[4] = new PointXD(tempPoint[0], tempPoint[1]);
        this.repositionedFeature1[4] = new PointXD(0.0, 0.0);
        this.repositionedFeature2[4] = new PointXD(0.0, 0.0);
        tempPoint = newSplines.getSpline(0).getBeginPoint();
        this.featurePoints[5] = new PointXD(tempPoint[0], tempPoint[1]);
        tempPoint = newSplines.getSpline(5).getEndPoint();
        this.featurePoints[6] = new PointXD(tempPoint[0], tempPoint[1]);
        double[] delta = new double[]{this.featurePoints[1].getX() - this.featurePoints[6].getX(), this.featurePoints[1].getY() - this.featurePoints[6].getY()};
        double tmp = delta[1] * delta[1] + delta[0] * delta[0];
        delta[0] = delta[0] / tmp;
        delta[1] = delta[1] / tmp;
        for (j = 0; j < this.noFeaturePointsSmall; ++j) {
            this.repositionedFeature1[j] = new PointXD((this.featurePoints[j].getX() - this.featurePoints[6].getX()) * delta[0] + (this.featurePoints[j].getY() - this.featurePoints[6].getY()) * delta[1], -(this.featurePoints[j].getX() - this.featurePoints[6].getX()) * delta[1] + (this.featurePoints[j].getY() - this.featurePoints[6].getY()) * delta[0]);
        }
        delta[0] = this.featurePoints[2].getX() - this.featurePoints[6].getX();
        delta[1] = this.featurePoints[2].getY() - this.featurePoints[6].getY();
        tmp = delta[1] * delta[1] + delta[0] * delta[0];
        delta[0] = delta[0] / tmp;
        delta[1] = delta[1] / tmp;
        for (j = 0; j < this.noFeaturePointsSmall; ++j) {
            this.repositionedFeature2[j] = new PointXD((this.featurePoints[j].getX() - this.featurePoints[6].getX()) * delta[0] + (this.featurePoints[j].getY() - this.featurePoints[6].getY()) * delta[1], -(this.featurePoints[j].getX() - this.featurePoints[6].getX()) * delta[1] + (this.featurePoints[j].getY() - this.featurePoints[6].getY()) * delta[0]);
        }
        for (int i = 0; i < this.noFeaturePointsSmall; ++i) {
            match[i] = -1;
        }
        for (int j2 = 0; j2 < noJoints; ++j2) {
            double distance = StrictMath.hypot((double)this.joints[j2].x - this.userPoints[0].getX(), (double)this.joints[j2].y - this.userPoints[0].getY());
            if (distance < 180.0) continue;
            double error = this.evaluate(this.userPoints[0], this.joints[j2], this.repositionedFeature1, tmp_match);
            if (error < minerr) {
                minerr = error;
                System.arraycopy(tmp_match, 0, match, 0, this.noFeaturePointsSmall);
            }
            if (!((error = this.evaluate(this.userPoints[0], this.joints[j2], this.repositionedFeature2, tmp_match)) < minerr)) continue;
            minerr = error;
            System.arraycopy(tmp_match, 0, match, 0, this.noFeaturePointsSmall);
        }
        int k = 0;
        for (int i = 0; i < this.noFeaturePointsSmall; ++i) {
            if (match[i] < 0) continue;
            this.bestFeaturePoints[i] = new PointXD((double)this.joints[match[i]].x, (double)this.joints[match[i]].y);
            ++k;
        }
        if (k < 2) {
            throw new SpliningException();
        }
        this.bestFeaturePoints[5] = new PointXD(this.userPoints[1].getX(), this.userPoints[1].getY());
        this.bestFeaturePoints[6] = new PointXD(this.userPoints[0].getX(), this.userPoints[0].getY());
        match[5] = 1;
        if (match[0] >= 0) {
            match[4] = -1;
        }
        this.determineAffineTransformation(this.featurePoints, this.bestFeaturePoints, match);
    }

    public Matrix affineAlternative(PointXD[] featurePoints, PointXD[] bestFeaturePoints) {
        Matrix target = new Matrix(featurePoints);
        Matrix reference = new Matrix(bestFeaturePoints);
        return Geometrics.uniformShapeChange(target, reference);
    }

    private void determineAffineTransformation(PointXD[] featurePoints, PointXD[] bestFeaturePoints, int[] match) {
        int i;
        int n = 6;
        double[][] R = new double[12][4];
        double[] Q = new double[12];
        double[][] A = new double[4][4];
        double[] B = new double[4];
        int k = 0;
        for (i = 0; i < n; ++i) {
            if (match[i] < 0) continue;
            R[k][0] = featurePoints[i].getX() - featurePoints[n].getX();
            R[k][1] = featurePoints[i].getY() - featurePoints[n].getY();
            R[k][2] = 0.0;
            R[k][3] = 0.0;
            Q[k] = bestFeaturePoints[i].getX() - bestFeaturePoints[n].getX();
            R[++k][0] = 0.0;
            R[k][1] = 0.0;
            R[k][2] = featurePoints[i].getX() - featurePoints[n].getX();
            R[k][3] = featurePoints[i].getY() - featurePoints[n].getY();
            Q[k] = bestFeaturePoints[i].getY() - bestFeaturePoints[n].getY();
            ++k;
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int h = 0; h < k; ++h) {
                    double[] dArray = A[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + R[h][i] * R[h][j];
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (int h = 0; h < k; ++h) {
                int n3 = i;
                B[n3] = B[n3] + Q[h] * R[h][i];
            }
        }
        LUDecomposition lu = new LUDecomposition(new Matrix(A));
        double[][] X = lu.solve(new Matrix(B)).getData();
        this.affine[0] = X[0][0];
        this.affine[1] = X[1][0];
        this.affine[2] = bestFeaturePoints[n].getX() - (this.affine[0] * featurePoints[n].getX() + this.affine[1] * featurePoints[n].getY());
        this.affine[3] = X[2][0];
        this.affine[4] = X[3][0];
        this.affine[5] = bestFeaturePoints[n].getY() - (this.affine[3] * featurePoints[n].getX() + this.affine[4] * featurePoints[n].getY());
    }

    private double evaluate(PointXD ref0, Point ref1, PointXD[] f, int[] fmatch) {
        int j;
        int i;
        double[] fdist = new double[6];
        double accp_zone = 0.2;
        for (i = 0; i < this.noFeaturePointsSmall; ++i) {
            fdist[i] = accp_zone * accp_zone;
            fmatch[i] = -1;
        }
        double sc = ref1.getX() - ref0.getX();
        double ss = ref1.getY() - ref0.getY();
        double tmp = ss * ss + sc * sc;
        sc /= tmp;
        ss /= tmp;
        int nj = this.joints.length;
        for (i = 0; i < nj; ++i) {
            double u = ((double)this.joints[i].x - ref0.getX()) * sc + ((double)this.joints[i].y - ref0.getY()) * ss;
            double v = -((double)this.joints[i].x - ref0.getX()) * ss + ((double)this.joints[i].y - ref0.getY()) * sc;
            if (this.ind.getSide() == 1) {
                v = -v;
            }
            double dmin = 100000.0;
            int target = 0;
            for (j = 0; j < this.noFeaturePointsSmall; ++j) {
                double d = StrictMath.hypot(f[j].getX() - u, f[j].getY() - v);
                if (!(d < dmin)) continue;
                target = j;
                dmin = d;
            }
            if (!(dmin < fdist[target])) continue;
            fdist[target] = dmin;
            fmatch[target] = i;
        }
        double score = 0.0;
        for (j = 0; j < this.noFeaturePointsSmall; ++j) {
            score += fdist[j];
        }
        return score;
    }

    private SplineGroup mapmodel() {
        this.registeredSplines = this.splines.splineGroupCopy();
        int noCurves = this.splines.getNoSplines();
        Spline tempSpline = null;
        double[][] data = null;
        double[] temp = new double[]{0.0, 0.0};
        for (int x = 0; x < noCurves; ++x) {
            tempSpline = this.splines.getSpline(x);
            int n = tempSpline.getNoPoints();
            data = tempSpline.getData();
            for (int i = 0; i < n; ++i) {
                temp[0] = this.affine[0] * data[i][0] + this.affine[1] * data[i][1] + this.affine[2];
                temp[1] = this.affine[3] * data[i][0] + this.affine[4] * data[i][1] + this.affine[5];
                data[i][0] = temp[0];
                data[i][1] = temp[1];
            }
            this.registeredSplines.setSpline(x, new Spline(data, this.ind.getDistortions()));
        }
        return this.registeredSplines;
    }

    int findfeature(double x1, double y1, Point[] joints) {
        int k = 0;
        double mindis = 10000.0;
        int n = joints.length;
        for (int i = 0; i < n; ++i) {
            double x = (double)joints[i].x - x1;
            double y = (double)joints[i].y - y1;
            if (!(x * x + y * y < mindis)) continue;
            k = i;
            mindis = x * x + y * y;
        }
        if (mindis < 100.0) {
            return k;
        }
        return -1;
    }

    public SplineGroup getRawSplineGroup() {
        return this.splines;
    }

    public SplineGroup getRegisteredSplineGroup() {
        return this.registeredSplines;
    }

    public double[] getAffineTransformations() {
        return this.affine;
    }

    private void print(double[][] values) {
        String temp = "";
        for (int x = 0; x < values.length; ++x) {
            for (int y = 0; y < values[0].length; ++y) {
                temp = temp + values[x][y] + "\t";
            }
            temp = temp + "\n";
        }
        System.out.println(temp);
    }

    private void print(double[] values) {
        String temp = "";
        for (int x = 0; x < values.length; ++x) {
            temp = temp + values[x] + "\n";
        }
        System.out.println(temp);
    }
}

