/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import com.sun.media.jai.codec.SeekableStream;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.SwingWorker;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.outliers.SplineCheck;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.splining.FitSplines;
import kim.bin.bio.wings.splining.PixelProcessing;
import kim.bin.bio.wings.splining.RegisterSplineModel;
import kim.bin.bio.wings.splining.SpliningParameterSet;
import kim.image.advanced.SinglePixelFilters;
import kim.image.advanced.convolutionkernels.KernelSizeException;
import kim.image.advanced.convolutionkernels.SpatialFilters;

public class ImageProcessing
extends SwingWorker<Individual[], Object>
implements IndividualStatus {
    protected static final long serialVersionUID = 1L;
    protected SeekableStream originalImageStream = null;
    protected BufferedImage originalImage = null;
    protected byte[] rawByteData;
    protected int[][] rawData;
    protected int[][] invertedData = null;
    protected int[][] smoothedData = null;
    protected int[][] openedData = null;
    protected int[][] thresholdData = null;
    protected int[][] filledData = null;
    protected int[][] skeletonData = null;
    protected int[][] removeShortSegmentData = null;
    protected int[][] removeLongSegmentData = null;
    protected int width;
    protected int height;
    protected IndGroup individuals = null;
    protected RegisterSplineModel rsm = null;
    protected FitSplines fs = null;
    protected SplineGroup fitSplines = null;
    protected SpliningParameterSet splineParameters = null;
    protected boolean defaultSpliningParameters = true;

    public ImageProcessing(IndGroup individuals) {
        this.individuals = individuals;
    }

    public ImageProcessing(IndGroup individuals, boolean defaultSpliningParameters) {
        this.individuals = individuals;
        this.defaultSpliningParameters = defaultSpliningParameters;
    }

    public ImageProcessing(Individual ind) {
        this.process(ind);
    }

    public ImageProcessing() {
    }

    @Override
    protected Individual[] doInBackground() throws Exception {
        System.out.println("Process images");
        Individual[] allIndividuals = this.individuals.toArray();
        int noIndividuals = allIndividuals.length;
        for (int x = 0; x < noIndividuals; ++x) {
            if (!GlobalVariables.processing) continue;
            allIndividuals[x].setSplineGroup(this.process(0, allIndividuals[x]));
            this.firePropertyChange("Updated", x, allIndividuals[x]);
        }
        return allIndividuals;
    }

    @Override
    protected void done() {
        this.firePropertyChange("All splined", null, null);
        Toolkit.getDefaultToolkit().beep();
    }

    protected void process(Individual ind) {
        this.process(0, ind);
    }

    public SplineGroup process(int start, Individual ind) {
        if (!ind.hasRawImageData()) {
            try {
                this.rawData = ind.loadRawImageData();
            }
            catch (IOException ex) {
                ind.setProcessingStatus(2);
            }
        } else {
            this.rawData = ind.getRawImageData();
        }
        if (!ind.hasIndividualSplineParameters) {
            ind.setSpliningParameters(GlobalVariables.spliningParameters);
        } else if (this.defaultSpliningParameters) {
            ind.setSpliningParameters(GlobalVariables.spliningParameters);
        }
        try {
            switch (start) {
                case 0: {
                    this.invertedData = SinglePixelFilters.invert(this.rawData);
                    this.smoothedData = SpatialFilters.medianSmoothing(this.invertedData, 3);
                }
                case 1: {
                    this.openedData = PixelProcessing.opening(this.smoothedData, ind.splineParameters.openRadius, (double)ind.splineParameters.structElementHeight);
                }
                case 2: {
                    this.thresholdData = SinglePixelFilters.threshold(this.openedData, ind.splineParameters.threshold);
                }
                case 3: {
                    this.filledData = PixelProcessing.fillOpenHoles(this.thresholdData, ind.splineParameters.fillSize);
                }
                case 4: {
                    this.skeletonData = PixelProcessing.skeleton(this.filledData);
                }
                case 5: {
                    this.removeShortSegmentData = PixelProcessing.cleanup(this.skeletonData, ind.splineParameters.shortCleanSegment);
                }
                case 6: {
                    this.removeLongSegmentData = PixelProcessing.cleanup(this.removeShortSegmentData, ind.splineParameters.longCleanSegment);
                }
                case 7: {
                    System.out.println("UserMark Coordinates: " + ind.getUserMarkCoordinateValues(true, false)[0]);
                    this.rsm = new RegisterSplineModel(this.removeLongSegmentData, GlobalVariables.masterSplineGroup, ind.getUserMarkCoordinateValues(true, false), ind);
                    this.fs = new FitSplines(this.openedData, this.rsm.getRegisteredSplineGroup(), ind.getUserMarkCoordinateValues(true, false));
                    this.fitSplines = this.fs.fitSplines();
                    ind.setProcessingStatus(8);
                    ind.procrustesDistance = SplineCheck.evaluate(GlobalVariables.masterSplineGroup, this.fitSplines, ind.getUserMarkCoordinateValues(true, false), ind.getLandMarkDefinition());
                    ind.setSplineGroup(this.fitSplines);
                    ind.saveData(false);
                    return this.fitSplines;
                }
            }
        }
        catch (KernelSizeException kernelSizeException) {
            ind.setProcessingStatus(7);
        }
        return null;
    }

    private int[][] dataCopy(int[][] data) {
        int[][] newData = new int[data.length][data[0].length];
        for (int x = 0; x < data.length; ++x) {
            System.arraycopy(data[x], 0, newData[x], 0, data[0].length);
        }
        return newData;
    }
}

