/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.WingsInternalFrame;
import kim.bin.bio.wings.fileTypes.CPXFile;
import kim.bin.bio.wings.images.DisplayImage;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.spline.SplinePropertyChoser;
import kim.util.JGridBag;

public class SplinePropertiesFrame
extends WingsInternalFrame {
    private static final long serialVersionUID = 1L;
    int noSplines = 0;
    private JLabel header = new JLabel("    Spline Properties");
    SplinePropertyChoser[] lines;
    JButton saveFile = new JButton("Save modified spline model");
    SplineGroup splines;
    Dimension d = new Dimension(22, 22);
    DisplayImage imageDisplay = new DisplayImage();
    boolean editMode = false;

    public SplinePropertiesFrame() {
        super("temp");
    }

    public SplinePropertiesFrame(SplineGroup sg) {
        super("Spline properties");
        this.imageDisplay.setEditMode(this.editMode);
        this.header.setFont(new Font(null, 0, 16));
        JGridBag.add(this.content, (Component)this.header, 1, 0, 3, 1, 15, 0, 0, 15);
        JGridBag.add(this.content, (Component)this.imageDisplay, 0, 0, 1, 100, 15, 15, 15, 10);
        this.pack();
        this.setLocation(GlobalVariables.width - this.getWidth() - 15, GlobalVariables.height - this.getHeight() - 60);
        this.setSplineGroup(sg);
        this.validate();
        this.setVisible(true);
        this.saveFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SplinePropertiesFrame.this.saveFile();
            }
        });
    }

    public Color getColor(int splineNumber) {
        return this.lines[splineNumber].getColor();
    }

    public void setColors(Color[] colors) {
        GlobalVariables.colors = colors;
    }

    public void setSplineGroup(SplineGroup splines) {
        this.imageDisplay.setSplineGroup(splines, true);
        if (splines != null) {
            this.noSplines = splines.getNoSplines();
            this.lines = new SplinePropertyChoser[this.noSplines];
            this.imageDisplay.setText("");
            for (int i = 0; i < this.noSplines; ++i) {
                this.lines[i] = new SplinePropertyChoser(GlobalVariables.colors[i % GlobalVariables.colors.length], i, splines.getSpline(i));
                this.lines[i].setEditable(this.editMode);
                JGridBag.add(this.content, (Component)this.lines[i], 2, i + 1, 1, 1, 0, 0, i == this.noSplines - 1 ? 25 : 0, 25);
                this.lines[i].addPropertyChangeListener("SplineColorsChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SplinePropertiesFrame.this.imageDisplay.repaint();
                    }
                });
            }
        }
        this.pack();
        this.setLocation(GlobalVariables.width - this.getWidth() - 15, GlobalVariables.height - this.getHeight() - 60);
    }

    public void saveFile() {
        CPXFile.saveModelFile(this.splines);
    }

    public static void main(String[] args) {
        Individual[] ind = new Individual[]{Individual.getTestIndividual(), Individual.getTestIndividual2()};
        GlobalVariables.workDirectory = new File("C:\\wings\\java\\");
        JFrame f = new JFrame("Test unit");
        SplinePropertiesFrame spf = new SplinePropertiesFrame(ind[0].getSplineGroup());
        f.add(spf);
        f.setSize(1600, 1000);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

