/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import commonSense.math.curves.BSpline;
import commonSense.math.curves.BSplineMath;
import commonSense.math.linear.Matrix;
import kim.bin.bio.wings.PointMatrix;

public class Spline
extends PointMatrix {
    private static final long serialVersionUID = 1L;
    protected BSpline bSpline = null;
    protected BSplineMath bmath = null;

    public Spline(double[][] d, double[] distortions) {
        super(d, distortions);
        this.initMath();
    }

    private void initMath() {
        this.bSpline = new BSpline(2, this.getData());
        this.bmath = new BSplineMath(this.bSpline);
    }

    @Override
    public void setData(double[][] inData) {
        super.setData(inData);
        this.initMath();
    }

    public void setValue(int row, int column, double value) {
        this.setEntry(row, column, value);
    }

    @Override
    public void setEntry(int row, int column, double value) {
        super.setEntry(row, column, value);
        this.initMath();
    }

    public void insertControlPoint(double x, double y) {
        double[] d = new double[]{x, y};
        int g = this.findRank(x, y);
        System.out.println("Add at " + g);
        this.insertRow(d, g);
    }

    public void insertControlPoint(double[] values, int position) {
        this.insertRow(values, position);
    }

    public void removeControlPoint(int position) {
        this.removeRow(position);
    }

    @Override
    public void insertRow(double[] values, int row) {
        super.insertRow(values, row);
        this.initMath();
    }

    @Override
    public void removeRow(int row) {
        super.removeRow(row);
        this.initMath();
    }

    public double[] getEndPoint() {
        return this.getRow(this.getNoPoints() - 1);
    }

    public double[] getBeginPoint() {
        return this.getRow(0);
    }

    public int getEndPointNo() {
        return this.getNoPoints() - 1;
    }

    public BSpline getBSpline() {
        return this.bSpline;
    }

    public BSplineMath getBSplineMath() {
        return this.bmath;
    }

    public Matrix getSemiLandMarks(int numberOfSemiLandMarks) {
        return new Matrix(this.bmath.extractPoints(this.bmath.estimateTValues(numberOfSemiLandMarks - 1)));
    }

    public Matrix getSemiLandMarks(int numberOfSemiLandMarks, boolean distortionCorrection, boolean rotationCorrection) {
        double[][] newData = this.bmath.extractPoints(this.bmath.estimateTValues(numberOfSemiLandMarks - 1));
        double[] dis = new double[this.columns];
        double[] cors = new double[this.columns];
        for (int a = 0; a < this.columns; ++a) {
            dis[a] = distortionCorrection ? this.distortions[a] : 1.0;
            cors[a] = rotationCorrection ? this.corrections[a] : 0.0;
        }
        for (int x = 0; x < newData.length; ++x) {
            for (int y = 0; y < newData[0].length; ++y) {
                newData[x][y] = StrictMath.abs(cors[y] - newData[x][y] * dis[y]);
            }
        }
        return new Matrix(newData);
    }

    public Spline getAffineTransformedCopy(Matrix uniform) {
        double[] out = new double[this.columns];
        System.arraycopy(this.distortions, 0, out, 0, this.columns);
        Matrix newData = this.multiply(uniform);
        return new Spline(newData.getData(), out);
    }

    public Spline splineCopy() {
        double[] out = new double[this.columns];
        System.arraycopy(this.distortions, 0, out, 0, this.columns);
        return new Spline(this.getData(), out);
    }

    @Override
    public String toLinearString(String delim) {
        return "" + this.getNoPoints() + delim + super.toLinearString(delim);
    }

    @Override
    public String toString() {
        return this.toString("\t");
    }

    public String toString(String delim) {
        return "" + this.getNoPoints() + "\n\r" + super.toSquareString(delim);
    }

    private int findRank(double x, double y) {
        double d12;
        System.out.println(this.data.toString());
        System.out.println("Point in case: (" + x + "," + y + ")");
        double distance = -1.0;
        double minDistance = Double.MAX_VALUE;
        int cp = -1;
        for (int i = 0; i < this.rows; ++i) {
            distance = Math.hypot(this.data[i][0] - x, this.data[i][1] - y);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            cp = i;
        }
        if (cp == 0) {
            return 0;
        }
        if (cp == this.rows) {
            return this.rows;
        }
        double dx = Math.hypot(this.data[cp - 1][0] - x, this.data[cp - 1][1] - y);
        if (dx > (d12 = Math.hypot(this.data[cp - 1][0] - this.data[cp][0], this.data[cp - 1][1] - this.data[cp][1]))) {
            return cp + 1;
        }
        return cp;
    }
}

