/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JButton;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplinePropertiesFrame;
import kim.bin.bio.wings.spline.SplinePropertyChoser;
import kim.util.JGridBag;

public class MasterSplineGeneratorFrame
extends SplinePropertiesFrame {
    private static final long serialVersionUID = 1L;
    private JButton newSplineGroup = new JButton("Create new cpXfile");
    private JButton modify = new JButton("Modify model");
    private JButton add = new JButton("Add Spline");

    private void increaseCapacity() {
        SplinePropertyChoser[] newLines = new SplinePropertyChoser[this.noSplines + 1];
        for (int i = 0; i < this.noSplines; ++i) {
            newLines[i] = this.lines[i];
        }
        this.lines = newLines;
        ++this.noSplines;
    }

    private void addSpline(int rankOrder, Spline spline) {
        System.out.println(rankOrder + " " + this.noSplines);
        if (rankOrder > this.noSplines) {
            this.increaseCapacity();
        }
        System.out.println(rankOrder + " " + this.noSplines);
        this.splines.addSpline(spline);
        this.lines[--rankOrder] = new SplinePropertyChoser(GlobalVariables.colors[rankOrder % GlobalVariables.colors.length], rankOrder, spline);
        JGridBag.add(this.content, (Component)this.lines[rankOrder], 1, rankOrder + 1, 1, 1);
        this.validate();
    }

    public void addSpline(int noCp) {
        double[][] rawData = new double[noCp][2];
        for (int i = 0; i < noCp; ++i) {
            rawData[i][0] = 5.0 * (double)i;
            rawData[i][1] = 5.0 * (double)i;
        }
        double[] distortions = new double[]{1.0, 1.0};
        this.addSpline(this.noSplines + 1, new Spline(rawData, distortions));
        this.imageDisplay.setEditMode(true);
        this.imageDisplay.setMagnification(2.5f);
        this.saveFile.setVisible(true);
        this.setSize(1200, 800);
        this.setLocation(15, 60);
        this.validate();
    }
}

